/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.integration.griefdefender;

import com.flowpowered.math.vector.Vector3i;
import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.api.Tracking;
import com.github.terminatornl.tiquality.integration.griefdefender.AdminClaimTracker;
import com.github.terminatornl.tiquality.integration.griefdefender.EventHandler;
import com.github.terminatornl.tiquality.integration.griefdefender.event.GDClaimCreatedFullyEvent;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import com.github.terminatornl.tiquality.util.ForgeData;
import com.github.terminatornl.tiquality.util.Scheduler;
import com.github.terminatornl.tiquality.world.WorldHelper;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.ClaimType;
import com.griefdefender.api.claim.ClaimTypes;
import com.griefdefender.api.event.ChangeClaimEvent;
import com.griefdefender.api.event.CreateClaimEvent;
import com.griefdefender.api.event.TransferClaimEvent;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.event.EventSubscriber;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.World;

public class GriefDefenderHook {
    private static final CreateClaimEventHandler createClaimHandler = new CreateClaimEventHandler();
    private static final ChangeClaimEventHandler claimChangeHandler = new ChangeClaimEventHandler();
    private static final TransferClaimEventHandler transferClaimHandler = new TransferClaimEventHandler();

    public static void setClaimTrackers(Claim claim, Tracker tracker, Runnable callback, Runnable beforeRun) {
        Vector3i least = claim.getLesserBoundaryCorner();
        Vector3i most = claim.getGreaterBoundaryCorner();
        GriefDefenderHook.resizeClaimTrackers(claim, least, most, tracker, callback, beforeRun);
    }

    public static void resizeClaimTrackers(Claim claim, Vector3i least, Vector3i most, Tracker tracker, Runnable callback, Runnable beforeRun) {
        if (least == null || most == null) {
            return;
        }
        Optional worldOpt = Sponge.getServer().getWorld(claim.getWorldUniqueId());
        if (!worldOpt.isPresent()) {
            return;
        }
        TiqualityWorld world = (TiqualityWorld)worldOpt.get();
        BlockPos leastPos = new BlockPos(least.getX(), least.getY(), least.getZ());
        BlockPos mostPos = new BlockPos(most.getX(), most.getY(), most.getZ());
        world.setTiqualityTrackerCuboidAsync(leastPos, mostPos, tracker, callback, beforeRun);
    }

    public static void loadClaimsForcibly(final ICommandSender sender) {
        final AtomicInteger counter = new AtomicInteger(0);
        Tiquality.LOGGER.info("Importing griefdefender claims...");
        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Import started."));
        ArrayList list = new ArrayList();
        for (World world : Sponge.getServer().getWorlds()) {
            list.addAll(GriefDefender.getCore().getClaimManager(world.getUniqueId()).getWorldClaims());
        }
        for (Claim claim : list) {
            if (!GriefDefenderHook.isValidClaim(claim)) continue;
            counter.getAndIncrement();
            UUID owner = claim.getOwnerUniqueId();
            Optional worldOpt = Sponge.getServer().getWorld(claim.getWorldUniqueId());
            if (!worldOpt.isPresent()) {
                return;
            }
            net.minecraft.world.World world = (net.minecraft.world.World)worldOpt.get();
            Vector3i pos = claim.getLesserBoundaryCorner();
            final String identifier = (owner != null ? owner : "Unknown") + " at DIM=" + (world != null ? String.valueOf(world.field_73011_w.getDimension()) : "Unknown") + " " + (pos != null ? "X: " + pos.getX() + " Z: " + pos.getZ() : "unknown");
            GriefDefenderHook.setClaimTrackers(claim, PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)world, ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId())), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String message = Tiquality.PREFIX + "Remaining claims: " + (counter.getAndDecrement() - 1);
                    Tiquality.LOGGER.info(message);
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + message));
                    AtomicInteger atomicInteger = counter;
                    synchronized (atomicInteger) {
                        counter.notifyAll();
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    Tiquality.LOGGER.info("Importing: " + identifier);
                }
            });
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (counter.get() > 0) {
                        AtomicInteger atomicInteger = counter;
                        synchronized (atomicInteger) {
                            counter.wait(5000L);
                        }
                        int tasks = WorldHelper.getQueuedTasks();
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + tasks + " tasks to process left."));
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Import finished."));
                    Tiquality.LOGGER.info("Import finished.");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static boolean isValidClaim(Claim claim) {
        boolean isInvalid = claim == null || claim.isWilderness() || claim.getOwnerUniqueId() == null;
        return !isInvalid;
    }

    @Nullable
    public static Tracker findOrGetTrackerByClaim(@Nonnull Claim claim) {
        if (claim.isWilderness()) {
            return null;
        }
        if (claim.isAdminClaim()) {
            return AdminClaimTracker.INSTANCE;
        }
        if (claim.getOwnerUniqueId() == null) {
            throw new IllegalArgumentException("Claim owner is null!");
        }
        GameProfile profile = ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId());
        Optional worldOpt = Sponge.getServer().getWorld(claim.getWorldUniqueId());
        if (!worldOpt.isPresent()) {
            return null;
        }
        return PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)worldOpt.get(), profile);
    }

    public static void importSingleClaim(final EntityPlayer sender) throws CommandException {
        BlockPos pos = sender.func_180425_c();
        Claim claim = GriefDefender.getCore().getClaimManager(((World)sender.func_130014_f_()).getUniqueId()).getClaimAt(new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        if (claim == null) {
            throw new CommandException("Claim not found, please stand in your claim where no tracker is present and run the command again.", new Object[0]);
        }
        if (!GriefDefenderHook.isValidClaim(claim)) {
            throw new CommandException("Claim is found, but it is not of a valid type.", new Object[0]);
        }
        TiqualityWorld world = (TiqualityWorld)sender.func_130014_f_();
        Tracker existingTracker = world.getTiqualityTracker(pos);
        if (existingTracker != null) {
            throw new CommandException("There's already a tracker present: " + existingTracker.getInfo().func_150265_g(), new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "[Tiquality] Import queued."));
        Vector3i least = claim.getLesserBoundaryCorner();
        Vector3i most = claim.getGreaterBoundaryCorner();
        if (least == null || most == null) {
            return;
        }
        BlockPos leastPos = new BlockPos(least.getX(), least.getY(), least.getZ());
        BlockPos mostPos = new BlockPos(most.getX(), most.getY(), most.getZ());
        world.setTiqualityTrackerCuboidAsync(leastPos, mostPos, PlayerTracker.getOrCreatePlayerTrackerByProfile(world, ForgeData.getGameProfileByUUID(claim.getOwnerUniqueId())), new Runnable(){

            @Override
            public void run() {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Importing your claim..."));
            }
        }, new Runnable(){

            @Override
            public void run() {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Import complete!"));
            }
        });
    }

    public static void init() {
        GriefDefender.getEventManager().getBus().register(CreateClaimEvent.class, (EventSubscriber)createClaimHandler);
        GriefDefender.getEventManager().getBus().register(ChangeClaimEvent.class, (EventSubscriber)claimChangeHandler);
        GriefDefender.getEventManager().getBus().register(TransferClaimEvent.class, (EventSubscriber)transferClaimHandler);
        Tracking.registerCustomTracker("GDAdmin", AdminClaimTracker.class);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
    }

    private static class TransferClaimEventHandler
    implements EventSubscriber<TransferClaimEvent> {
        private TransferClaimEventHandler() {
        }

        public void invoke(@Nonnull TransferClaimEvent event) {
            for (Claim claim : event.getClaims()) {
                Tracker tracker = GriefDefenderHook.findOrGetTrackerByClaim(claim);
                if (tracker == null) continue;
                GriefDefenderHook.setClaimTrackers(claim, tracker, null, null);
            }
        }
    }

    private static class ChangeClaimEventHandler
    implements EventSubscriber<ChangeClaimEvent> {
        private ChangeClaimEventHandler() {
        }

        public int postOrder() {
            return 100;
        }

        public void invoke(@Nonnull ChangeClaimEvent event) {
            if (event.cancelled()) {
                return;
            }
            if (event instanceof ChangeClaimEvent.Type) {
                ChangeClaimEvent.Type typeChangeEvent = (ChangeClaimEvent.Type)event;
                for (final Claim claim : event.getClaims()) {
                    ClaimType originalType = typeChangeEvent.getOriginalType();
                    ClaimType newType = typeChangeEvent.getType();
                    if (originalType == ClaimTypes.BASIC || originalType == ClaimTypes.TOWN || originalType == ClaimTypes.SUBDIVISION) {
                        if (newType != ClaimTypes.ADMIN) continue;
                        GriefDefenderHook.setClaimTrackers(claim, AdminClaimTracker.INSTANCE, null, null);
                        continue;
                    }
                    if (originalType != ClaimTypes.ADMIN || newType != ClaimTypes.BASIC && newType != ClaimTypes.TOWN && newType != ClaimTypes.SUBDIVISION) continue;
                    final Vector3i lesser = claim.getLesserBoundaryCorner();
                    Scheduler.INSTANCE.schedule(new Runnable(){

                        @Override
                        public void run() {
                            Optional worldOpt = Sponge.getServer().getWorld(claim.getWorldUniqueId());
                            if (!worldOpt.isPresent()) {
                                return;
                            }
                            TiqualityWorld world = (TiqualityWorld)worldOpt.get();
                            Tracker newTracker = GriefDefenderHook.findOrGetTrackerByClaim(GriefDefender.getCore().getClaimManager(((World)world).getUniqueId()).getClaimAt(lesser));
                            if (newTracker == null) {
                                return;
                            }
                            GriefDefenderHook.setClaimTrackers(claim, newTracker, null, null);
                        }
                    });
                }
            } else if (event instanceof ChangeClaimEvent.Resize) {
                ChangeClaimEvent.Resize claimEvent = (ChangeClaimEvent.Resize)event;
                final Claim claim = claimEvent.getClaim();
                final Tracker tracker = GriefDefenderHook.findOrGetTrackerByClaim(claim);
                if (tracker == null) {
                    return;
                }
                Tiquality.SCHEDULER.schedule(new Runnable(){

                    @Override
                    public void run() {
                        GriefDefenderHook.resizeClaimTrackers(claim, claim.getLesserBoundaryCorner(), claim.getGreaterBoundaryCorner(), tracker, null, null);
                    }
                });
            }
        }
    }

    private static class CreateClaimEventHandler
    implements EventSubscriber<CreateClaimEvent> {
        private CreateClaimEventHandler() {
        }

        public void invoke(final @Nonnull CreateClaimEvent event) {
            Tiquality.SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Claim claim : event.getClaims()) {
                        MinecraftForge.EVENT_BUS.post((Event)new GDClaimCreatedFullyEvent(claim));
                    }
                }
            });
        }
    }
}

