/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.command;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.command.PermissionHolder;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.PermissionAPI;

public class ForgePermissionHolder
implements PermissionHolder {
    private final ICommandSender sender;

    public ForgePermissionHolder(ICommandSender sender) {
        this.sender = sender;
    }

    @Override
    public boolean hasPermission(PermissionHolder.Permission permission) {
        if (this.sender instanceof MinecraftServer) {
            return true;
        }
        if (this.sender instanceof EntityPlayer) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)this.sender), (String)permission.getNode());
        }
        Tiquality.LOGGER.info("Unknown command sender type: " + this.sender.getClass().getName());
        return false;
    }

    @Override
    public void checkPermission(PermissionHolder.Permission permission) throws CommandException {
        if (!this.hasPermission(permission)) {
            throw new CommandException("Sorry, you don't have permission to use this command. (" + permission.getNode() + ")", new Object[0]);
        }
    }

    @Override
    public void sendMessage(ITextComponent message) {
        this.sender.func_145747_a(message);
    }
}

