/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.command;

import com.github.terminatornl.tiquality.Tiquality;
import com.github.terminatornl.tiquality.TiqualityConfig;
import com.github.terminatornl.tiquality.api.Location;
import com.github.terminatornl.tiquality.api.TiqualityException;
import com.github.terminatornl.tiquality.command.PermissionHolder;
import com.github.terminatornl.tiquality.integration.ExternalHooker;
import com.github.terminatornl.tiquality.integration.griefdefender.GriefDefenderHook;
import com.github.terminatornl.tiquality.integration.griefprevention.GriefPreventionHook;
import com.github.terminatornl.tiquality.interfaces.TiqualityChunk;
import com.github.terminatornl.tiquality.interfaces.TiqualityEntity;
import com.github.terminatornl.tiquality.interfaces.TiqualityWorld;
import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.interfaces.UpdateTyped;
import com.github.terminatornl.tiquality.monitor.InfoMonitor;
import com.github.terminatornl.tiquality.monitor.TrackingTool;
import com.github.terminatornl.tiquality.profiling.AnalyzedComponent;
import com.github.terminatornl.tiquality.profiling.ProfileReport;
import com.github.terminatornl.tiquality.profiling.ReferencedTickable;
import com.github.terminatornl.tiquality.profiling.SimpleProfiler;
import com.github.terminatornl.tiquality.profiling.TickTime;
import com.github.terminatornl.tiquality.tracking.PlayerTracker;
import com.github.terminatornl.tiquality.tracking.TrackerManager;
import com.github.terminatornl.tiquality.tracking.UpdateType;
import com.github.terminatornl.tiquality.util.ForgeData;
import com.github.terminatornl.tiquality.util.Teleporting;
import com.github.terminatornl.tiquality.util.Utils;
import com.github.terminatornl.tiquality.world.WorldHelper;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandExecutor {
    public static void incorrectUsageError(ICommandSender sender, PermissionHolder holder) throws CommandException {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Running Tiquality version: " + TextFormatting.AQUA + "FAT-1.12.2-GAMMA-1.8.1-124"));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentString(CommandExecutor.getUsage(holder)));
        throw new CommandException("Hint: Press TAB for suggestions.", new Object[0]);
    }

    public static String getUsage(PermissionHolder holder) {
        StringBuilder builder = new StringBuilder();
        if (holder.hasPermission(PermissionHolder.Permission.USE)) {
            builder.append("Usage: /tiquality <info [point] | track | share | notify | profile <secs>");
        }
        if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
            builder.append(" [target] | reload | setblock | setentity | unclaim");
        }
        if (holder.hasPermission(PermissionHolder.Permission.CLAIM)) {
            builder.append(" | claim");
        }
        return builder.toString();
    }

    public static void execute(final ICommandSender sender, String[] args, final PermissionHolder holder) throws CommandException {
        holder.checkPermission(PermissionHolder.Permission.USE);
        if (args.length == 0) {
            CommandExecutor.incorrectUsageError(sender, holder);
        }
        if (args[0].equalsIgnoreCase("reload") || args[0].equalsIgnoreCase("rl")) {
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Reloading..."));
            TiqualityConfig.QuickConfig.reloadFromFile();
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Done!"));
        } else if (args[0].equalsIgnoreCase("goto")) {
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the 'goto' command.", new Object[0]);
            }
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            EntityPlayer player = (EntityPlayer)sender;
            if (args.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This command is not intended to be typed manually... Instead: Click on one of the profile results!"));
                throw new CommandException("Usage: /goto <identifier>", new Object[0]);
            }
            String identifier = args[1];
            byte[] bytes = Base64.getDecoder().decode(identifier.getBytes());
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            ReferencedTickable.ReferenceId referenceId = new ReferencedTickable.ReferenceId(buf);
            ReferencedTickable.Reference reference = referenceId.convert();
            Location<Integer, BlockPos> pos = reference.currentPos();
            if (pos == null) {
                throw new CommandException("Sorry, the current position is unknown.", new Object[0]);
            }
            sender.func_145747_a(new TextComponentString(Tiquality.PREFIX + "Teleporting to: ").func_150257_a(reference.getName()));
            Teleporting.attemptTeleportWithGameMode3(player, pos.getWorld(), pos.getPos());
        } else if (args[0].equalsIgnoreCase("share")) {
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the 'share' command.", new Object[0]);
            }
            holder.checkPermission(PermissionHolder.Permission.USE);
            PlayerTracker tracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)sender.func_130014_f_(), ((EntityPlayer)sender).func_146103_bH());
            if (args.length != 2) {
                List<TextComponentString> list = tracker.getSharedToTextual((TiqualityWorld)sender.func_130014_f_());
                if (list.size() > 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "You are currently sharing your tick time with: "));
                    for (TextComponentString t : list) {
                        sender.func_145747_a(new TextComponentString(Tiquality.PREFIX).func_150257_a((ITextComponent)t));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "You are currently sharing your tick time nobody."));
                }
                throw new CommandException("To change: /tiquality share [name]", new Object[0]);
            }
            String name = args[1];
            GameProfile targetPlayer = ForgeData.getGameProfileByName(name);
            if (targetPlayer == null) {
                throw new CommandException("Sorry, the user '" + name + "' was not found.", new Object[0]);
            }
            PlayerTracker targetTracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)sender.func_130014_f_(), targetPlayer);
            boolean newState = tracker.switchSharedTo(targetTracker.getHolder().getId());
            if (newState) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "You are now sharing your tick time with: " + TextFormatting.GREEN + targetPlayer.getName()));
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "If you want to stop sharing your time, run this command again!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "You are no longer sharing your tick time with: " + TextFormatting.RED + targetPlayer.getName()));
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "If you want to share your time again, run this command again!"));
            }
        } else if (args[0].equalsIgnoreCase("info")) {
            TextComponentString message;
            Tracker tracker;
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the 'info' command.", new Object[0]);
            }
            holder.checkPermission(PermissionHolder.Permission.USE);
            EntityPlayer player = (EntityPlayer)sender;
            if (args.length > 1 && args[1].equalsIgnoreCase("point")) {
                new InfoMonitor((EntityPlayerMP)player).start(5000);
                return;
            }
            TiqualityChunk tiqualityChunk = (TiqualityChunk)player.func_130014_f_().func_175726_f(player.func_180425_c());
            Tracker dominantTracker = tiqualityChunk.getCachedMostDominantTracker();
            Style style = new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(TextFormatting.WHITE + "When entities enter this chunk, they will be assigned to this tracker.")));
            if (dominantTracker != null) {
                sender.func_145747_a(new TextComponentString(Tiquality.PREFIX + "Most dominant tracker in this chunk: " + dominantTracker.getInfo().func_150254_d()).func_150255_a(style));
            } else {
                sender.func_145747_a(new TextComponentString(Tiquality.PREFIX + "There's no dominant tracker in this chunk.").func_150255_a(style));
            }
            if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
                LinkedList<ITextComponent> messages = new LinkedList<ITextComponent>();
                Chunk chunk = player.func_130014_f_().func_175726_f(player.func_180425_c());
                for (ClassInheritanceMultiMap classInheritanceMultiMap : chunk.func_177429_s()) {
                    for (Entity entity_raw : classInheritanceMultiMap) {
                        TiqualityEntity entity = (TiqualityEntity)entity_raw;
                        if (entity instanceof EntityPlayer) continue;
                        Tracker tracker2 = entity.getTracker();
                        messages.add(new TextComponentString(entity.tiquality_getResourceLocation() + " ").func_150257_a(entity.getUpdateType().getText(UpdateType.Type.ENTITY)).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)(tracker2 == null ? new TextComponentString(TextFormatting.GRAY + "Not tracked") : tracker2.getInfo())));
                    }
                }
                if (messages.size() == 0) {
                    player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "No entities are found in your chunk."));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Entities in chunk:"));
                    for (ITextComponent message2 : messages) {
                        player.func_145747_a(message2);
                    }
                }
            }
            World world = player.func_130014_f_();
            BlockPos blockPosAtFeet = player.func_180425_c();
            BlockPos blockPosBelowFeet = player.func_180425_c().func_177977_b();
            IBlockState stateAtFeet = player.func_130014_f_().func_180495_p(blockPosAtFeet);
            IBlockState stateBelowFeet = player.func_130014_f_().func_180495_p(blockPosBelowFeet);
            Block blockAtFeet = stateAtFeet.func_177230_c();
            Block blockBelowFeet = stateBelowFeet.func_177230_c();
            UpdateType feetUpdateType = ((UpdateTyped)blockAtFeet).getUpdateType();
            UpdateType belowUpdateType = ((UpdateTyped)blockBelowFeet).getUpdateType();
            boolean isBlockAtFeetAir = blockAtFeet.isAir(stateAtFeet, (IBlockAccess)world, blockPosAtFeet);
            boolean isBlockBelowFeetAir = blockBelowFeet.isAir(stateBelowFeet, (IBlockAccess)world, blockPosBelowFeet);
            if (isBlockAtFeetAir && isBlockBelowFeetAir) {
                player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "If you wish to see info about a block, please stand on it and run this command again."));
                return;
            }
            if (!isBlockBelowFeetAir) {
                tracker = ((TiqualityWorld)player.func_130014_f_()).getTiqualityTracker(player.func_180425_c().func_177977_b());
                message = tracker == null ? new TextComponentString(TextFormatting.AQUA + "Not tracked") : tracker.getInfo();
                player.func_145747_a(new TextComponentString(Tiquality.PREFIX + "Block below: " + TextFormatting.YELLOW + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockBelowFeet)).toString() + TextFormatting.WHITE + " TickType: ").func_150257_a(belowUpdateType.getText(UpdateType.Type.BLOCK)).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + " Status: " + message.func_150265_g())));
            }
            if (!isBlockAtFeetAir) {
                tracker = ((TiqualityWorld)player.func_130014_f_()).getTiqualityTracker(player.func_180425_c());
                message = tracker == null ? new TextComponentString(TextFormatting.AQUA + "Not tracked") : tracker.getInfo();
                player.func_145747_a(new TextComponentString(Tiquality.PREFIX + "Block at feet: " + TextFormatting.YELLOW + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockAtFeet)).toString() + TextFormatting.WHITE + " TickType: ").func_150257_a(feetUpdateType.getText(UpdateType.Type.BLOCK)).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + " Status: " + message.func_150265_g())));
            }
        } else if (args[0].equalsIgnoreCase("track")) {
            if (!(sender instanceof EntityPlayerMP)) {
                throw new CommandException("Only players can use this command!", new Object[0]);
            }
            holder.checkPermission(PermissionHolder.Permission.USE);
            int time = 5;
            if (args.length >= 2) {
                time = CommandBase.func_175764_a((String)args[1], (int)0, (int)60);
            }
            new TrackingTool((EntityPlayerMP)sender).start(time * 1000);
        } else if (args[0].equalsIgnoreCase("setblock")) {
            UpdateType updateType;
            Block blockToAdd;
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the 'setblock' command.", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)sender;
            if (args.length != 3) {
                sender.func_145747_a(new TextComponentString(TextFormatting.RED + "Usage: setblock <feet|below> ").func_150257_a(UpdateType.getArguments(UpdateType.Type.BLOCK, TextFormatting.RED)));
                throw new CommandException("Hover over the different update types to see more info!", new Object[0]);
            }
            String mode = args[1];
            if (mode.equalsIgnoreCase("feet")) {
                blockToAdd = player.func_130014_f_().func_180495_p(player.func_180425_c()).func_177230_c();
                if (player.func_130014_f_().func_175623_d(player.func_180425_c())) {
                    throw new CommandException("Please stand with your feet in a block (like water or a flower) and run this command again.", new Object[0]);
                }
            } else if (mode.equalsIgnoreCase("below")) {
                blockToAdd = player.func_130014_f_().func_180495_p(player.func_180425_c().func_177977_b()).func_177230_c();
                if (player.func_130014_f_().func_175623_d(player.func_180425_c().func_177977_b())) {
                    throw new CommandException("Please stand on top of a block and run this command again.", new Object[0]);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid input: '" + mode + "'. Expected 'feet' or 'below'"));
                sender.func_145747_a(new TextComponentString(TextFormatting.RED + "Usage: setblock <feet|below> ").func_150257_a(UpdateType.getArguments(UpdateType.Type.BLOCK, TextFormatting.RED)));
                throw new CommandException("Hover over the different update types to see more info!", new Object[0]);
            }
            String type = args[2].toUpperCase();
            try {
                updateType = UpdateType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                sender.func_145747_a(new TextComponentString(TextFormatting.RED + "Invalid update type! Valid types: ").func_150257_a(UpdateType.getArguments(UpdateType.Type.BLOCK, TextFormatting.RED)));
                throw new CommandException("Hover over the different update types to see more info!", new Object[0]);
            }
            Tiquality.SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    ResourceLocation resourceLocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockToAdd);
                    TiqualityConfig.QuickConfig.setBlockUpdateType(updateType, resourceLocation);
                    TiqualityConfig.QuickConfig.saveToFile();
                    TiqualityConfig.QuickConfig.update();
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Updated: " + TextFormatting.YELLOW + resourceLocation + TextFormatting.GREEN + ". New tick type: " + updateType.getText(UpdateType.Type.BLOCK).func_150254_d()));
                }
            });
        } else if (args[0].equalsIgnoreCase("setentity")) {
            ArrayList<Object> AFFECTED_ENTITIES;
            UpdateType updateType;
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            if (args.length != 3) {
                sender.func_145747_a(new TextComponentString(TextFormatting.RED + "Usage: setentity <resource or regex> ").func_150257_a(UpdateType.getArguments(UpdateType.Type.ENTITY, TextFormatting.RED)));
                throw new CommandException("Hover over the different update types to see more info!", new Object[0]);
            }
            String entity_name = args[1];
            String type = args[2].toUpperCase();
            try {
                updateType = UpdateType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                sender.func_145747_a(new TextComponentString(TextFormatting.RED + "Invalid update type! Valid types: ").func_150257_a(UpdateType.getArguments(UpdateType.Type.ENTITY, TextFormatting.RED)));
                throw new CommandException("Hover over the different update types to see more info!", new Object[0]);
            }
            Set ENTITY_LIST = EntityList.func_180124_b();
            if (!entity_name.contains(":") && !entity_name.startsWith("REGEX=")) {
                throw new CommandException("Invalid format! Required either a resourcelocation or a string starting with REGEX=", new Object[0]);
            }
            if (entity_name.startsWith("REGEX=")) {
                AFFECTED_ENTITIES = TiqualityConfig.QuickConfig.findEntities(ENTITY_LIST, entity_name.substring(6));
                if (AFFECTED_ENTITIES.size() == 0) {
                    throw new CommandException("No targets have been found for your regex entry.", new Object[0]);
                }
            } else {
                String[] split = entity_name.split(":");
                ResourceLocation location = new ResourceLocation(split[0], split[1]);
                if (!ENTITY_LIST.contains(location)) {
                    throw new CommandException("Sorry, this entity type cannot be found. Domain: " + split[0] + " path: " + split[1] + ". Expected something like: minecraft:pig", new Object[0]);
                }
                AFFECTED_ENTITIES = new ArrayList();
                AFFECTED_ENTITIES.add(location);
            }
            Tiquality.SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    TiqualityConfig.QuickConfig.setEntityUpdateType(updateType, AFFECTED_ENTITIES.toArray(new ResourceLocation[0]));
                    for (ResourceLocation resourceLocation : AFFECTED_ENTITIES) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Updated: " + TextFormatting.YELLOW + resourceLocation + TextFormatting.GREEN + ". New tick type: " + updateType.getText(UpdateType.Type.ENTITY).func_150254_d()));
                    }
                    TiqualityConfig.QuickConfig.saveToFile();
                    TiqualityConfig.QuickConfig.update();
                }
            });
        } else if (args[0].equalsIgnoreCase("claim")) {
            int range;
            holder.checkPermission(PermissionHolder.Permission.CLAIM);
            if (args.length > 1) {
                try {
                    range = CommandBase.func_175764_a((String)args[1], (int)1, (int)TiqualityConfig.MAX_CLAIM_RADIUS);
                }
                catch (NumberInvalidException e) {
                    throw new CommandException("Range must be between 0 and " + TiqualityConfig.MAX_CLAIM_RADIUS, new Object[0]);
                }
            } else {
                range = TiqualityConfig.MAX_CLAIM_RADIUS;
            }
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("You must be a player to use this command.", new Object[0]);
            }
            final EntityPlayer player = (EntityPlayer)sender;
            BlockPos leastPos_pre = player.func_180425_c().func_177982_a(range * -1, 0, range * -1);
            BlockPos mostPos_pre = player.func_180425_c().func_177982_a(range, 0, range);
            final BlockPos leastPos = new BlockPos(leastPos_pre.func_177958_n(), 0, leastPos_pre.func_177952_p());
            final BlockPos mostPos = new BlockPos(mostPos_pre.func_177958_n(), player.field_70170_p.func_72800_K() - 1, mostPos_pre.func_177952_p());
            List<ChunkPos> affectedChunks = WorldHelper.getAffectedChunksInCuboid(leastPos.func_177982_a(-16, 0, -16), mostPos.func_177982_a(16, 0, 16));
            World world = player.func_130014_f_();
            final GameProfile profile = player.func_146103_bH();
            final LinkedList<PlayerTracker> affectedPlayerTrackers = new LinkedList<PlayerTracker>();
            for (ChunkPos pos : affectedChunks) {
                TiqualityChunk chunk = (TiqualityChunk)world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
                chunk.recalculateDominatingTracker();
                Tracker tracker = chunk.getCachedMostDominantTracker();
                if (tracker == null) continue;
                if (!(tracker instanceof PlayerTracker)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Sorry, there's already a tracker nearby that prevents you " + TextFormatting.RED + "from claiming here. (" + tracker.getInfo().func_150260_c() + TextFormatting.RED + ")"));
                    if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
                        throw new CommandException("Use /tiquality unclaim to resolve this. Keep in mind that for claiming land at least one completely unclaimed chunk must be left as spacing between different owners of trackers.", new Object[0]);
                    }
                    throw new CommandException("Ask an admin to unclaim this piece of land for you", new Object[0]);
                }
                PlayerTracker playerTracker = (PlayerTracker)tracker;
                GameProfile trackerProfile = playerTracker.getOwner();
                if (trackerProfile.equals((Object)profile) || affectedPlayerTrackers.contains(playerTracker)) continue;
                affectedPlayerTrackers.add(playerTracker);
            }
            final World affectedWorld = player.field_70170_p;
            if (affectedPlayerTrackers.size() > 0) {
                PlayerTracker.ClaimOverrideRequester requester = new PlayerTracker.ClaimOverrideRequester(){
                    private final List<PlayerTracker> requests;
                    private boolean isDenied;
                    {
                        this.requests = new LinkedList<PlayerTracker>(affectedPlayerTrackers);
                        this.isDenied = false;
                    }

                    @Override
                    public void onDeny(PlayerTracker tracker) {
                        if (this.isDenied) {
                            return;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + TextFormatting.RED + "Your claim override request was denied by: " + tracker.getOwner().getName()));
                        this.isDenied = true;
                    }

                    @Override
                    public void onOfflineOwner(PlayerTracker tracker) {
                        if (this.isDenied) {
                            return;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + TextFormatting.RED + tracker.getOwner().getName() + " is not online, and cannot verify your claim request. You have to wait until all owners are online."));
                        this.isDenied = true;
                    }

                    @Override
                    public void onAccept(PlayerTracker existingTracker) {
                        this.requests.remove(existingTracker);
                        if (this.isDenied) {
                            return;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + existingTracker.getOwner().getName() + " accepted your request."));
                        if (this.requests.size() == 0) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Everyone accepted your request. Claiming..."));
                            PlayerTracker tracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)affectedWorld, profile);
                            ((TiqualityWorld)player.func_130014_f_()).setTiqualityTrackerCuboidAsync(leastPos, mostPos, tracker, new Runnable(){

                                @Override
                                public void run() {
                                    sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Done."));
                                }
                            });
                        } else {
                            for (PlayerTracker request : this.requests) {
                                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Waiting for: " + request.getOwner().getName()));
                            }
                        }
                    }

                    @Override
                    public GameProfile getProfile() {
                        return profile;
                    }
                };
                StringBuilder builder = new StringBuilder();
                for (PlayerTracker affectedPlayerTracker : affectedPlayerTrackers) {
                    builder.append(TextFormatting.RED.toString());
                    builder.append(affectedPlayerTracker.getOwner().getName());
                    builder.append(", ");
                }
                String existingOwners = builder.substring(0, Math.max(builder.length() - 2, 0));
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + TextFormatting.RED + "There already are trackers within this radius (" + range + " + " + 16 + "). Sending a request to the following owner(s): " + existingOwners));
                for (PlayerTracker affectedPlayerTracker : affectedPlayerTrackers) {
                    affectedPlayerTracker.requestClaimOverride(requester, affectedWorld, leastPos, mostPos);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Claiming area in a " + range + " block radius: x=" + leastPos.func_177958_n() + " z=" + leastPos.func_177952_p() + " to x=" + mostPos.func_177958_n() + " z=" + mostPos.func_177952_p()));
                PlayerTracker tracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)player.field_70170_p, player.func_146103_bH());
                ((TiqualityWorld)affectedWorld).setTiqualityTrackerCuboidAsync(leastPos, mostPos, tracker, new Runnable(){

                    @Override
                    public void run() {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Done."));
                    }
                });
            }
        } else if (args[0].equalsIgnoreCase("unclaim")) {
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            int range = 0;
            if (args.length > 1) {
                try {
                    range = CommandBase.func_180528_a((String)args[1], (int)1);
                }
                catch (NumberInvalidException e) {
                    throw new CommandException("Range must be more than 0!", new Object[0]);
                }
            }
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("You must be a player to use this command.", new Object[0]);
            }
            if (range == 0) {
                throw new CommandException("There's no default unclaim radius to prevent accidental data loss. Please specify it.", new Object[0]);
            }
            final EntityPlayer player = (EntityPlayer)sender;
            BlockPos leastPos = player.func_180425_c().func_177982_a(range * -1, 0, range * -1);
            BlockPos mostPos = player.func_180425_c().func_177982_a(range, 0, range);
            leastPos = new BlockPos(leastPos.func_177958_n(), 0, leastPos.func_177952_p());
            mostPos = new BlockPos(mostPos.func_177958_n(), player.field_70170_p.func_72800_K() - 1, mostPos.func_177952_p());
            player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Unclaiming area in a " + range + " block radius: x=" + leastPos.func_177958_n() + " z=" + leastPos.func_177952_p() + " to x=" + mostPos.func_177958_n() + " z=" + mostPos.func_177952_p()));
            ((TiqualityWorld)player.func_130014_f_()).setTiqualityTrackerCuboidAsync(leastPos, mostPos, null, new Runnable(){

                @Override
                public void run() {
                    player.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Done."));
                }
            });
        } else if (args[0].equalsIgnoreCase("acceptoverride")) {
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the acceptoverride command!", new Object[0]);
            }
            if (args.length != 2) {
                throw new CommandException("Usage: /tiquality acceptoverride <name>", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)sender;
            PlayerTracker tracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)player.field_70170_p, player.func_146103_bH());
            tracker.acceptOverride(sender, args[1]);
        } else if (args[0].equalsIgnoreCase("denyoverride")) {
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the denyoverride command!", new Object[0]);
            }
            if (args.length != 2) {
                throw new CommandException("Usage: /tiquality denyoverride <name>", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)sender;
            PlayerTracker tracker = PlayerTracker.getOrCreatePlayerTrackerByProfile((TiqualityWorld)player.field_70170_p, player.func_146103_bH());
            tracker.denyOverride(sender, args[1]);
        } else if (args[0].equalsIgnoreCase("notify")) {
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use the notify command!", new Object[0]);
            }
            final EntityPlayer player = (EntityPlayer)sender;
            boolean newNotifySetting = TrackerManager.foreach(new TrackerManager.Action<PlayerTracker>(){

                @Override
                public void each(Tracker tracker) {
                    if (tracker instanceof PlayerTracker && ((PlayerTracker)tracker).getOwner().getId().equals(player.func_146103_bH().getId())) {
                        this.stop((PlayerTracker)tracker);
                    }
                }
            }).switchNotify();
            sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Notifications " + (newNotifySetting ? "enabled" : "disabled") + "."));
        } else if (args[0].equalsIgnoreCase("profile")) {
            GameProfile target_player;
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (args.length == 1) {
                CommandExecutor.incorrectUsageError(sender, holder);
            }
            int time = CommandBase.func_175764_a((String)args[1], (int)1, (int)30);
            if (args.length == 3) {
                String target = args[2];
                holder.checkPermission(PermissionHolder.Permission.ADMIN);
                target_player = ForgeData.getGameProfileByName(target);
            } else {
                if (!(sender instanceof EntityPlayer)) {
                    throw new CommandException("You need to specify a playername or UUID.", new Object[0]);
                }
                target_player = ((EntityPlayer)sender).func_146103_bH();
            }
            if (target_player == null) {
                throw new CommandException("Player not found.", new Object[0]);
            }
            final LinkedList trackersToProfile = new LinkedList();
            TrackerManager.foreach(new TrackerManager.Action<Object>(){

                @Override
                public void each(Tracker tracker) {
                    if (tracker.canProfile() && tracker.getAssociatedPlayers().contains(target_player)) {
                        trackersToProfile.add(tracker);
                    }
                }
            });
            if (trackersToProfile.size() == 0) {
                throw new CommandException("Player is found, but there are no trackers associated.", new Object[0]);
            }
            for (Tracker tracker : trackersToProfile) {
                SimpleProfiler profiler = new SimpleProfiler(tracker, time * 1000, new SimpleProfiler.ProfilePrinter(){

                    @Override
                    public void progressUpdate(ITextComponent message) {
                        message.func_150256_b().func_150238_a(TextFormatting.GRAY);
                        sender.func_145747_a(new TextComponentString(Tiquality.PREFIX).func_150257_a(message));
                    }

                    @Override
                    public void report(ProfileReport report) {
                        LinkedList<Object> messages = new LinkedList<Object>();
                        Iterator<AnalyzedComponent> componentIterator = report.getAnalyzedComponents().descendingIterator();
                        for (int i = 0; i < 50 && componentIterator.hasNext(); ++i) {
                            AnalyzedComponent component = componentIterator.next();
                            long muPerTick = Math.round(report.getMuPerTick(component.getTimes()));
                            double callsPerTick = report.getCallsPerTick(component.getTimes());
                            String stats = TextFormatting.DARK_AQUA + report.getTrackerImpactPercentage(component.getTimes()) + TextFormatting.GRAY + "% " + TextFormatting.WHITE + muPerTick + TextFormatting.GRAY + "\u00b5s/t " + TextFormatting.WHITE + Utils.ONE_DECIMAL_FORMATTER.format(callsPerTick) + TextFormatting.GRAY + "c/t " + component.getLocationString() + TextFormatting.GRAY + " ";
                            StringBuilder name = new StringBuilder(component.getFriendlyName());
                            int upperBound = name.length();
                            int freeCharacters = 85 - stats.length();
                            int suggestedLength = Math.min(upperBound, Math.max(3, freeCharacters));
                            boolean ellipsis = false;
                            if (suggestedLength < name.length()) {
                                ellipsis = true;
                            }
                            name = new StringBuilder(name.substring(0, suggestedLength));
                            if (ellipsis) {
                                name.append("...");
                            }
                            Style style = new Style();
                            ResourceLocation location = component.getResourceLocation();
                            TextComponentString hoverString = new TextComponentString(Tiquality.PREFIX + "Details" + TextFormatting.GRAY + "\nName: " + TextFormatting.WHITE + component.getFriendlyName() + TextFormatting.GRAY + "\nResource: " + TextFormatting.WHITE + (location == null ? "Not available" : location.toString()) + TextFormatting.GRAY + "\nClass: " + TextFormatting.WHITE + component.getReferencedClass() + "\n" + TextFormatting.GRAY + "\nImpact on server: " + TextFormatting.WHITE + report.getServerImpactPercentage(component.getTimes()) + "% " + TextFormatting.DARK_GRAY + "(Approx.)" + TextFormatting.GRAY + "\nImpact on tracker: " + TextFormatting.WHITE + report.getTrackerImpactPercentage(component.getTimes()) + "%\n" + TextFormatting.GRAY + "\n\u00b5s per tick: " + TextFormatting.WHITE + muPerTick + TextFormatting.DARK_GRAY + " (Approx.)" + TextFormatting.GRAY + "\nCalls per tick: " + TextFormatting.WHITE + Utils.TWO_DECIMAL_FORMATTER.format(callsPerTick) + "\n" + TextFormatting.GRAY + "\nServer TPS: " + TextFormatting.WHITE + Utils.TWO_DECIMAL_FORMATTER.format(report.getServerTPS()) + TextFormatting.GRAY + "\nTracker TPS: " + TextFormatting.WHITE + Utils.TWO_DECIMAL_FORMATTER.format(report.getTrackerTPS()) + "\n" + TextFormatting.GRAY + "\nServer ticks measured: " + TextFormatting.WHITE + Utils.TWO_DECIMAL_FORMATTER.format(report.getServerTicks()) + TextFormatting.GRAY + "\nTracker ticks measured: " + TextFormatting.WHITE + Utils.TWO_DECIMAL_FORMATTER.format(report.getTrackerTicks()));
                            if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
                                hoverString.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GRAY + "\n\nClick to teleport!"));
                                ByteBuf buf = Unpooled.buffer();
                                component.getReferenceId().toBytes(buf);
                                byte[] bytes = new byte[buf.readableBytes()];
                                buf.readBytes(bytes);
                                String referenceString = new String(Base64.getEncoder().encode(bytes));
                                style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tiquality goto " + referenceString));
                            }
                            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverString));
                            messages.add(new TextComponentString(stats + name).func_150255_a(style));
                        }
                        messages.add(new TextComponentString(Tiquality.PREFIX + TextFormatting.GREEN + TextFormatting.BOLD + "By object"));
                        Iterator<Map.Entry<String, TickTime>> classIterator = report.getClassTimesSorted().descendingIterator();
                        for (int i = 0; i < 50 && classIterator.hasNext(); ++i) {
                            Map.Entry<String, TickTime> entry = classIterator.next();
                            messages.add(new TextComponentString(TextFormatting.DARK_AQUA + report.getTrackerImpactPercentage(entry.getValue()) + TextFormatting.GRAY + "% " + TextFormatting.GRAY + entry.getKey()));
                        }
                        messages.add(new TextComponentString(Tiquality.PREFIX + TextFormatting.GREEN + TextFormatting.BOLD + "By class"));
                        messages.add(new TextComponentString(Tiquality.PREFIX + TextFormatting.GREEN + TextFormatting.BOLD + "REPORT"));
                        messages.descendingIterator().forEachRemaining(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
                        sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Hover over the text for more details!"));
                    }
                });
                try {
                    profiler.start();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Tiquality.PREFIX + "Profiler started"));
                }
                catch (TiqualityException.TrackerAlreadyProfilingException e) {
                    throw new CommandException("Already profiling!", new Object[0]);
                }
                catch (TiqualityException e) {
                    e.printStackTrace();
                    sender.func_145747_a(e.getTextComponent());
                }
            }
        } else if (args[0].equalsIgnoreCase("debug")) {
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            final HashSet set = new HashSet();
            TrackerManager.foreach(new TrackerManager.Action<Object>(){

                @Override
                public void each(Tracker tracker) {
                    set.add(tracker);
                }
            });
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Loaded tracker objects (" + set.size() + "):"));
            for (Tracker e : set) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + e.toString()));
            }
            if (sender instanceof Entity) {
                String trackerTextBelow;
                String trackerTextFeet;
                Entity entity = (Entity)sender;
                BlockPos feet = entity.func_180425_c();
                String blockNameFeet = entity.func_130014_f_().func_180495_p(feet).func_177230_c().toString();
                boolean isMarkedFeet = ((TiqualityWorld)entity.func_130014_f_()).tiquality_isMarkedThorough(feet);
                Tracker trackerFeet = ((TiqualityWorld)entity.func_130014_f_()).getTiqualityTracker(feet);
                String string = trackerTextFeet = trackerFeet == null ? TextFormatting.AQUA + "NOT TRACKED" : TextFormatting.WHITE + trackerFeet.getInfo().func_150265_g();
                if (isMarkedFeet) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("FEET: " + blockNameFeet + TextFormatting.RED + " MARKED " + trackerTextFeet));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("FEET: " + blockNameFeet + TextFormatting.GREEN + " NOT MARKED " + trackerTextFeet));
                }
                BlockPos below = entity.func_180425_c().func_177977_b();
                String blockNameBelow = entity.func_130014_f_().func_180495_p(below).func_177230_c().toString();
                boolean isMarkedBelow = ((TiqualityWorld)entity.func_130014_f_()).tiquality_isMarkedThorough(below);
                Tracker trackerBelow = ((TiqualityWorld)entity.func_130014_f_()).getTiqualityTracker(below);
                String string2 = trackerTextBelow = trackerBelow == null ? TextFormatting.AQUA + "NOT TRACKED" : TextFormatting.WHITE + trackerBelow.getInfo().func_150265_g();
                if (isMarkedBelow) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("BELOW: " + blockNameBelow + TextFormatting.RED + " MARKED " + trackerTextBelow));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("BELOW: " + blockNameBelow + TextFormatting.GREEN + " NOT MARKED " + trackerTextBelow));
                }
            }
        } else if (args[0].equalsIgnoreCase("import_griefprevention")) {
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            if (ExternalHooker.LOADED_HOOKS.contains("griefprevention")) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GriefPreventionHook.loadClaimsForcibly(sender);
                    }
                }, "Tiquality GP import thread").start();
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GriefPrevention not detected."));
            }
        } else if (args[0].equalsIgnoreCase("import_griefprevention_claim")) {
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use this command.", new Object[0]);
            }
            if (ExternalHooker.LOADED_HOOKS.contains("griefprevention")) {
                GriefPreventionHook.importSingleClaim((EntityPlayer)sender);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GriefPrevention not detected."));
            }
        } else if (args[0].equalsIgnoreCase("import_griefdefender")) {
            holder.checkPermission(PermissionHolder.Permission.ADMIN);
            if (ExternalHooker.LOADED_HOOKS.contains("griefdefender")) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GriefDefenderHook.loadClaimsForcibly(sender);
                    }
                }, "Tiquality GP import thread").start();
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GriefDefender not detected."));
            }
        } else if (args[0].equalsIgnoreCase("import_griefdefender_claim")) {
            holder.checkPermission(PermissionHolder.Permission.USE);
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Only players can use this command.", new Object[0]);
            }
            if (ExternalHooker.LOADED_HOOKS.contains("griefdefender")) {
                GriefDefenderHook.importSingleClaim((EntityPlayer)sender);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GriefDefender not detected."));
            }
        } else {
            CommandExecutor.incorrectUsageError(sender, holder);
        }
    }

    public static List<String> getSuggestions(@Nonnull String[] args, @Nonnull PermissionHolder holder) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            String start = args[0];
            CommandExecutor.addIfStartsWith(list, start, "track");
            CommandExecutor.addIfStartsWith(list, start, "info");
            CommandExecutor.addIfStartsWith(list, start, "profile");
            CommandExecutor.addIfStartsWith(list, start, "notify");
            CommandExecutor.addIfStartsWith(list, start, "share");
            CommandExecutor.addIfStartsWith(list, start, "acceptoverride");
            CommandExecutor.addIfStartsWith(list, start, "denyoverride");
            if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
                CommandExecutor.addIfStartsWith(list, start, "setblock");
                CommandExecutor.addIfStartsWith(list, start, "setentity");
                CommandExecutor.addIfStartsWith(list, start, "reload");
                CommandExecutor.addIfStartsWith(list, start, "unclaim");
            }
            if (holder.hasPermission(PermissionHolder.Permission.CLAIM)) {
                CommandExecutor.addIfStartsWith(list, start, "claim");
            }
        } else if (args.length == 2) {
            String start = args[1];
            if (args[0].equalsIgnoreCase("info")) {
                CommandExecutor.addIfStartsWith(list, start, "point");
            } else if (args[0].equalsIgnoreCase("setblock")) {
                CommandExecutor.addIfStartsWith(list, start, "below");
                CommandExecutor.addIfStartsWith(list, start, "feet");
            } else if (args[0].equalsIgnoreCase("setentity")) {
                CommandExecutor.addIfStartsWith(list, start, "PREFIX=");
                for (ResourceLocation location : EntityList.func_180124_b()) {
                    CommandExecutor.addIfStartsWith(list, start, location.toString());
                }
            } else if (args[0].equalsIgnoreCase("track")) {
                CommandExecutor.addIfStartsWith(list, start, "1");
                CommandExecutor.addIfStartsWith(list, start, "5");
                CommandExecutor.addIfStartsWith(list, start, "10");
                CommandExecutor.addIfStartsWith(list, start, "20");
            } else if (args[0].equalsIgnoreCase("profile")) {
                CommandExecutor.addIfStartsWith(list, start, "5");
            } else if (args[0].equalsIgnoreCase("claim") || args[0].equalsIgnoreCase("unclaim")) {
                if (holder.hasPermission(PermissionHolder.Permission.CLAIM)) {
                    CommandExecutor.addIfStartsWith(list, start, String.valueOf(TiqualityConfig.MAX_CLAIM_RADIUS));
                }
            } else if (args[0].equalsIgnoreCase("share")) {
                for (String onlinePlayerName : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72369_d()) {
                    CommandExecutor.addIfStartsWith(list, start, onlinePlayerName);
                }
            } else if (args[0].equalsIgnoreCase("acceptoverride") || args[0].equalsIgnoreCase("denyoverride")) {
                for (String onlinePlayerName : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72369_d()) {
                    CommandExecutor.addIfStartsWith(list, start, onlinePlayerName);
                }
            }
        } else if (args.length == 3) {
            String start = args[2];
            if (args[0].equalsIgnoreCase("profile")) {
                if (holder.hasPermission(PermissionHolder.Permission.ADMIN)) {
                    final HashSet profiles = new HashSet();
                    TrackerManager.foreach(new TrackerManager.Action<Object>(){

                        @Override
                        public void each(Tracker tracker) {
                            profiles.addAll(tracker.getAssociatedPlayers());
                        }
                    });
                    for (GameProfile profile : profiles) {
                        CommandExecutor.addIfStartsWith(list, start, profile.getName());
                    }
                }
            } else if (args[0].equalsIgnoreCase("setblock")) {
                for (UpdateType updateType : UpdateType.values()) {
                    CommandExecutor.addIfStartsWith(list, start, updateType.name());
                }
            } else if (args[0].equalsIgnoreCase("setentity")) {
                for (UpdateType updateType : UpdateType.values()) {
                    CommandExecutor.addIfStartsWith(list, start, updateType.name());
                }
            }
        }
        if (list.size() == 0) {
            holder.sendMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "No suggestions available. Did you make a typo?"));
        }
        return list;
    }

    public static void addIfStartsWith(ArrayList<String> list, String starts, String target) {
        if (target.toLowerCase().startsWith(starts.toLowerCase())) {
            list.add(target);
        }
    }
}

