/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tiquality.api;

import com.github.terminatornl.tiquality.interfaces.Tracker;
import com.github.terminatornl.tiquality.profiling.ProfilingKey;
import com.mojang.authlib.GameProfile;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TiqualityException
extends Exception {
    TiqualityException(String s) {
        super(s);
    }

    public ITextComponent getTextComponent() {
        return new TextComponentString(TextFormatting.RED + this.getMessage());
    }

    public static class InvalidKeyException
    extends TiqualityException {
        private final ProfilingKey key;

        public InvalidKeyException(Tracker tracker, ProfilingKey key) {
            super("Used wrong key to stop profiling on tracker: " + tracker.toString());
            this.key = key;
        }

        public ProfilingKey getExpectedKey() {
            return this.key;
        }
    }

    public static class TrackerWasNotProfilingException
    extends TiqualityException {
        public TrackerWasNotProfilingException(Tracker tracker) {
            super("Tracker " + tracker.toString() + " was not profiling!");
        }
    }

    public static class TrackerAlreadyProfilingException
    extends TiqualityException {
        public TrackerAlreadyProfilingException(Tracker tracker) {
            super("Tracker " + tracker.toString() + " is already profiling!");
        }
    }

    public static class TrackerCannotProfileException
    extends TiqualityException {
        public TrackerCannotProfileException(Tracker tracker) {
            super("Tracker " + tracker.toString() + " does not support profiling!");
        }
    }

    public static class ReadTheDocsException
    extends TiqualityException {
        public ReadTheDocsException(String text) {
            super("Welp! Looks like a programmer didn't read the documentation for Tiquality. Message: " + text);
        }
    }

    public static class PlayerTrackerNotFoundException
    extends TiqualityException {
        public PlayerTrackerNotFoundException(GameProfile profile) {
            super("No PlayerTracker exists for: " + profile.getName() + " with UUID: " + profile.getId());
        }
    }
}

