/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.CommandService;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.message.MessageService;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

public abstract class CmdPlugin {
    public static final Optional<URL> DISCORD = CmdUtils.parseURL("https://discord.gg/4wayq37");
    private static final Map<String, CmdPlugin> REGISTRY = Maps.newHashMap();
    private final PluginContainer container;
    private final Text prefix;
    private final Path directory;
    private final Logger logger;
    private final CommandService commands;
    private final MessageService messages;

    public CmdPlugin(PluginContainer container) {
        this.container = container;
        this.prefix = CmdUtils.toText("&c[&6" + container.getName() + "&c]&7 ");
        this.directory = Sponge.getConfigManager().getPluginConfig((Object)container).getDirectory();
        this.logger = container.getLogger();
        this.commands = CommandService.of(container);
        this.messages = this.getMessageService();
        REGISTRY.put(container.getId(), this);
    }

    private MessageService getMessageService() {
        Path translations = this.directory.resolve("translations");
        try {
            ((Asset)this.container.getAsset("messages.properties").get()).copyToDirectory(translations);
            return MessageService.of(translations, "messages");
        }
        catch (IOException e) {
            this.logger.error("An error occurred initializing message translations. Using internal copies.");
            return MessageService.of(this.container, "messages");
        }
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public Text getPrefix() {
        return this.prefix;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MessageService getMessages() {
        return this.messages;
    }

    public CommandService getCommands() {
        return this.commands;
    }

    public static ImmutableMap<String, CmdPlugin> getRegistry() {
        return ImmutableMap.copyOf(REGISTRY);
    }
}

