/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.tiles;

import al132.alib.Reference;
import al132.alib.tiles.ALTile;
import al132.alib.utils.Utils;
import al132.alib.utils.extensions.IItemHandlerKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lal132/alib/tiles/ALTileStackHandler;", "Lnet/minecraftforge/items/ItemStackHandler;", "size", "", "tile", "Lal132/alib/tiles/ALTile;", "(ILal132/alib/tiles/ALTile;)V", "getTile", "()Lal132/alib/tiles/ALTile;", "setTile", "(Lal132/alib/tiles/ALTile;)V", "clear", "", "damageSlot", "slot", "decrementSlot", "amount", "eject", "", "direction", "Lnet/minecraft/util/EnumFacing;", "incrementSlot", "amountToAdd", "onContentsChanged", "setOrIncrement", "stackToSet", "Lnet/minecraft/item/ItemStack;", "alib"})
public class ALTileStackHandler
extends ItemStackHandler {
    @NotNull
    private ALTile tile;

    public final void damageSlot(int slot) {
        ItemStack itemStack = this.getStackInSlot(slot);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.getStackInSlot(slot)");
        this.setStackInSlot(slot, Utils.INSTANCE.damage(itemStack));
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.tile.func_70296_d();
    }

    public final void clear() {
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)this.getSlots());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            this.setStackInSlot(it, ItemStack.field_190927_a);
        }
    }

    public final void incrementSlot(int slot, int amountToAdd) {
        ItemStack temp = IItemHandlerKt.get((IItemHandler)this, slot);
        if (temp.func_190916_E() + amountToAdd <= temp.func_77976_d()) {
            temp.func_190920_e(temp.func_190916_E() + amountToAdd);
        }
        this.setStackInSlot(slot, temp);
    }

    public final void setOrIncrement(int slot, @NotNull ItemStack stackToSet) {
        Intrinsics.checkParameterIsNotNull((Object)stackToSet, (String)"stackToSet");
        if (!stackToSet.func_190926_b()) {
            if (IItemHandlerKt.get((IItemHandler)this, slot).func_190926_b()) {
                this.setStackInSlot(slot, stackToSet);
            } else {
                this.incrementSlot(slot, stackToSet.func_190916_E());
            }
        }
    }

    public final void decrementSlot(int slot, int amount) {
        ItemStack temp = IItemHandlerKt.get((IItemHandler)this, slot);
        if (temp.func_190926_b()) {
            return;
        }
        if (temp.func_190916_E() - amount < 0) {
            return;
        }
        temp.func_190918_g(amount);
        if (temp.func_190916_E() <= 0) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        } else {
            this.setStackInSlot(slot, temp);
        }
    }

    public final boolean eject(@NotNull EnumFacing direction) {
        IItemHandler targetHandler;
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Capability<IItemHandler> capability = Reference.INSTANCE.getITEM_CAP();
        Intrinsics.checkExpressionValueIsNotNull(capability, (String)"ITEM_CAP");
        IItemHandler originHandler = this.tile.getCapability(capability, direction);
        TileEntity tileEntity = this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = targetHandler = tileEntity != null ? (IItemHandler)tileEntity.getCapability(Reference.INSTANCE.getITEM_CAP(), direction.func_176734_d()) : null;
        if (originHandler != null && targetHandler != null) {
            return IItemHandlerKt.tryInsertInto(originHandler, targetHandler);
        }
        return false;
    }

    @NotNull
    public final ALTile getTile() {
        return this.tile;
    }

    public final void setTile(@NotNull ALTile aLTile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)aLTile), (String)"<set-?>");
        this.tile = aLTile;
    }

    public ALTileStackHandler(int size, @NotNull ALTile tile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tile), (String)"tile");
        this.tile = tile;
        this.setSize(size);
    }
}

