/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.lib.capability.ex.CapabilityExplosiveEntity;
import icbm.classic.lib.explosive.ExplosiveHandler;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGrenade
extends Entity
implements IEntityAdditionalSpawnData {
    private EntityLivingBase thrower;
    public final CapabilityExplosiveEntity explosive = new CapabilityExplosiveEntity(this);

    public EntityGrenade(World par1World) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityGrenade setItemStack(ItemStack stack) {
        this.explosive.setStack(stack);
        return this;
    }

    public EntityGrenade setThrower(EntityLivingBase thrower) {
        this.thrower = thrower;
        return this;
    }

    public EntityLivingBase getThrower() {
        return this.thrower;
    }

    public EntityGrenade aimFromThrower() {
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.func_70047_e(), this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
        float horizontalOffset = 0.16f;
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return this;
    }

    public EntityGrenade spawn() {
        this.field_70170_p.func_72838_d((Entity)this);
        return this;
    }

    public EntityGrenade setThrowMotion(float energy) {
        float powerScale = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.8f * energy, 1.0f);
        return this;
    }

    public String func_70005_c_() {
        return "icbm.grenade." + this.explosive.getExplosiveData().getRegistryName();
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.explosive.serializeNBT());
    }

    public void readSpawnData(ByteBuf data) {
        this.explosive.deserializeNBT(Optional.ofNullable(ByteBufUtils.readTag((ByteBuf)data)).orElseGet(NBTTagCompound::new));
    }

    public void setThrowableHeading(double vx, double vy, double vz, float scale, float random) {
        float power = MathHelper.func_76133_a((double)(vx * vx + vy * vy + vz * vz));
        vx /= (double)power;
        vy /= (double)power;
        vz /= (double)power;
        vx += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        vy += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        vz += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        this.func_70016_h(vx *= (double)scale, vy *= (double)scale, vz *= (double)scale);
    }

    public void func_70016_h(double vx, double vy, double vz) {
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(vx * vx + vz * vz));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vx, vz) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vy, var7) * 180.0 / Math.PI);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float horizontalMag = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, horizontalMag) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float var17 = 0.98f;
        float gravity = 0.03f;
        if (this.func_70090_H()) {
            for (int var7 = 0; var7 < 4; ++var7) {
                float var19 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)var19, this.field_70163_u - this.field_70181_x * (double)var19, this.field_70161_v - this.field_70179_y * (double)var19, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            var17 = 0.8f;
        }
        this.field_70159_w *= (double)var17;
        this.field_70181_x *= (double)var17;
        this.field_70179_y *= (double)var17;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x *= 0.5;
        } else {
            this.field_70181_x -= (double)gravity;
        }
        this.tickFuse();
    }

    protected void tickFuse() {
        if (this.field_70173_aa > ICBMClassicAPI.EX_GRENADE_REGISTRY.getFuseTime(this, this.explosive.getExplosiveData().getRegistryID())) {
            this.triggerExplosion();
        } else {
            ICBMClassicAPI.EX_GRENADE_REGISTRY.tickFuse(this, this.explosive.getExplosiveData().getRegistryID(), this.field_70173_aa);
        }
    }

    protected void triggerExplosion() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        ExplosiveHandler.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)0.3f, this.field_70161_v, this.explosive.getExplosiveData().getRegistryID(), 1.0f, this.explosive.getCustomBlastData());
        this.func_70106_y();
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("explosive")) {
            this.explosive.deserializeNBT(nbt.func_74775_l("explosive"));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74782_a("explosive", (NBTBase)this.explosive.serializeNBT());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)ICBMClassicAPI.EXPLOSIVE_CAPABILITY.cast((Object)this.explosive);
        }
        return (T)super.getCapability(capability, facing);
    }
}

