/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopConfig;
import com.carrot.carrotshop.shop.Shop;
import java.math.BigDecimal;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class Bank
extends Shop {
    private static String type = "Bank";

    public Bank() {
    }

    public Bank(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.create.bank")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        String[] stringArray = new String[]{"cost", type};
        float cost = ShopConfig.getNode(stringArray).getFloat(0.0f);
        if (cost > 0.0f) {
            UniqueAccount buyerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
            TransactionResult result = buyerAccount.withdraw(this.getCurrency(), BigDecimal.valueOf(cost), CarrotShop.getCause());
            if (result.getResult() != ResultType.SUCCESS) {
                throw new ExceptionInInitializerError(Lang.SHOP_COST.replace("%type%", type).replace("%cost%", this.formatPrice(BigDecimal.valueOf(cost))));
            }
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE_COST.replace("%type%", type).replace("%cost%", this.formatPrice(BigDecimal.valueOf(cost)))}));
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        }
        this.done(player);
    }

    @Override
    public void info(Player player) {
        player.sendMessage((Text)Text.of((String)Lang.SHOP_BANK_HELP));
        this.update();
    }

    @Override
    public boolean trigger(Player player) {
        UniqueAccount account = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
        player.sendMessage((Text)Text.of((String)Lang.SHOP_BANK.replace("%bank%", this.formatPrice(account.getBalance(this.getCurrency())))));
        return true;
    }
}

