/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import java.io.File;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public class ShopConfig {
    private static File configFile;
    private static ConfigurationLoader<CommentedConfigurationNode> configManager;
    private static CommentedConfigurationNode config;

    public static void init(File rootDir) {
        configFile = new File(rootDir, "config.conf");
        configManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configFile.toPath())).build();
    }

    public static void load() {
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
                config = (CommentedConfigurationNode)configManager.load();
                configManager.save((ConfigurationNode)config);
            }
            config = (CommentedConfigurationNode)configManager.load();
        }
        catch (IOException e) {
            CarrotShop.getLogger().error(Lang.CMD_CONFIG_RELOAD_FILE);
            e.printStackTrace();
            return;
        }
        config.getNode(new Object[]{"taxes"}).setComment("Percentage of the displayed price that will not be given to shop owner. Note that this option might not work well if you are using special economy plugins such as the ones that use items as currency");
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"taxes", "Buy"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"taxes", "Sell"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"taxes", "DeviceOn"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"taxes", "DeviceOff"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"taxes", "Toggle"}), 0);
        config.getNode(new Object[]{"cost"}).setComment("Cost for creating a sign");
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "Bank"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "Buy"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "Sell"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "DeviceOn"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "DeviceOff"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "Toggle"}), 0);
        Utils.ensurePositiveNumber(config.getNode(new Object[]{"cost", "Trade"}), 0);
        config.getNode(new Object[]{"others", "emptyhand"}).setComment("If true, using signs require empty hands, see https://github.com/TheoKah/CarrotShop/issues/30");
        Utils.ensureBoolean(config.getNode(new Object[]{"others", "emptyhand"}), false);
        ShopConfig.save();
    }

    public static void save() {
        try {
            configManager.save((ConfigurationNode)config);
        }
        catch (IOException e) {
            CarrotShop.getLogger().error("Could not save config file !");
        }
    }

    public static CommentedConfigurationNode getNode(String ... path) {
        return config.getNode((Object[])path);
    }

    public static class Utils {
        public static void ensureString(CommentedConfigurationNode node, String def) {
            if (node.getString() == null) {
                node.setValue((Object)def);
            }
        }

        public static void ensurePositiveNumber(CommentedConfigurationNode node, Number def) {
            if (!(node.getValue() instanceof Number) || node.getDouble(-1.0) < 0.0) {
                node.setValue((Object)def);
            }
        }

        public static void ensureBoolean(CommentedConfigurationNode node, boolean def) {
            if (!(node.getValue() instanceof Boolean)) {
                node.setValue((Object)def);
            }
        }
    }
}

