/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.decoration;

import java.util.Random;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.worldgen.decoration.WorldGenBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BushGenerator
implements IWorldGenerator {
    private final WorldGenBush glowing_mushroom = new WorldGenBush(NCBlocks.glowing_mushroom.func_176223_P());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world, NCBlocks.glowing_mushroom.func_176223_P());
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world, IBlockState mushroom) {
        if (!NCConfig.mushroom_gen || NCConfig.mushroom_gen_size <= 0 || NCConfig.mushroom_gen_rate <= 0) {
            return;
        }
        int genRarity = Math.max(400 / NCConfig.mushroom_gen_rate, 1);
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (biome == null) {
            return;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && random.nextInt(genRarity) == 0) {
            int xSpawn = xPos + random.nextInt(16);
            int ySpawn = random.nextInt(128);
            int zSpawn = zPos + random.nextInt(16);
            BlockPos position = new BlockPos(xSpawn, ySpawn, zSpawn);
            this.glowing_mushroom.generateBush(random, world, position);
        }
    }
}

