/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.model;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.BlockModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderManager;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;

public abstract class ChamModel
extends BlockModel {
    private static final List<BakedQuad> EMPTY = new ArrayList<BakedQuad>(0);
    private IBlockState state;
    private List<BakedQuad>[] solidCache;
    private List<BakedQuad>[] cutoutCache;
    private List<BakedQuad>[] mippedCache;
    private List<BakedQuad>[] transCache;

    public ChamModel(IBlockState state, boolean mergeLayers, Object ... args) {
        this.state = state;
        if (state == null) {
            return;
        }
        if (!mergeLayers) {
            Block block = state.func_177230_c();
            if (block.canRenderInLayer(state, BlockRenderLayer.SOLID)) {
                this.solidCache = (List[])Array.newInstance(ArrayList.class, 7);
            }
            if (block.canRenderInLayer(state, BlockRenderLayer.CUTOUT)) {
                this.cutoutCache = (List[])Array.newInstance(ArrayList.class, 7);
            }
            if (block.canRenderInLayer(state, BlockRenderLayer.CUTOUT_MIPPED)) {
                this.mippedCache = (List[])Array.newInstance(ArrayList.class, 7);
            }
            if (block.canRenderInLayer(state, BlockRenderLayer.TRANSLUCENT)) {
                this.transCache = (List[])Array.newInstance(ArrayList.class, 7);
            }
        } else {
            this.solidCache = (List[])Array.newInstance(ArrayList.class, 7);
        }
        for (int i = 0; i < 7; ++i) {
            if (this.solidCache != null) {
                this.solidCache[i] = EMPTY;
            }
            if (this.cutoutCache != null) {
                this.cutoutCache[i] = EMPTY;
            }
            if (this.mippedCache != null) {
                this.mippedCache[i] = EMPTY;
            }
            if (this.transCache == null) continue;
            this.transCache[i] = EMPTY;
        }
        ChamRender renderer = ChamRenderManager.instance.getRenderer(null);
        this.renderStart(renderer, state, args);
        if (!mergeLayers) {
            if (this.solidCache != null) {
                renderer.startBaking(this.getFormat());
                this.renderSolidLayer(renderer, state, args);
                renderer.stopBaking();
                this.updateCache(this.solidCache, renderer);
            }
            if (this.cutoutCache != null) {
                renderer.startBaking(this.getFormat());
                this.renderCutoutLayer(renderer, state, args);
                renderer.stopBaking();
                this.updateCache(this.cutoutCache, renderer);
            }
            if (this.mippedCache != null) {
                renderer.startBaking(this.getFormat());
                this.renderMippedLayer(renderer, state, args);
                renderer.stopBaking();
                this.updateCache(this.mippedCache, renderer);
            }
            if (this.transCache != null) {
                renderer.startBaking(this.getFormat());
                this.renderTransLayer(renderer, state, args);
                renderer.stopBaking();
                this.updateCache(this.transCache, renderer);
            }
        } else {
            renderer.startBaking(this.getFormat());
            this.renderSolidLayer(renderer, state, args);
            this.renderCutoutLayer(renderer, state, args);
            this.renderMippedLayer(renderer, state, args);
            this.renderTransLayer(renderer, state, args);
            renderer.stopBaking();
            this.updateCache(this.solidCache, renderer);
        }
        this.renderEnd(renderer, state, args);
        ChamRenderManager.instance.releaseRenderer(renderer);
    }

    public IBlockState getState() {
        return this.state;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing facing, long rand) {
        int index = facing != null ? facing.func_176745_a() : 6;
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        if (renderLayer == null) {
            return this.solidCache != null ? this.solidCache[index] : EMPTY;
        }
        switch (renderLayer) {
            case SOLID: {
                return this.solidCache != null ? this.solidCache[index] : EMPTY;
            }
            case CUTOUT: {
                return this.cutoutCache != null ? this.cutoutCache[index] : EMPTY;
            }
            case CUTOUT_MIPPED: {
                return this.mippedCache != null ? this.mippedCache[index] : EMPTY;
            }
            case TRANSLUCENT: {
                return this.transCache != null ? this.transCache[index] : EMPTY;
            }
        }
        return EMPTY;
    }

    protected void renderStart(ChamRender renderer, IBlockState state, Object ... args) {
    }

    protected void renderEnd(ChamRender renderer, IBlockState state, Object ... args) {
    }

    protected void renderSolidLayer(ChamRender renderer, IBlockState state, Object ... args) {
    }

    protected void renderCutoutLayer(ChamRender renderer, IBlockState state, Object ... args) {
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
    }

    private void updateCache(List<BakedQuad>[] cache, ChamRender renderer) {
        cache[6] = renderer.takeBakedQuads(null);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            cache[facing.func_176745_a()] = renderer.takeBakedQuads(facing);
        }
    }

    public static class NullModel
    extends ChamModel {
        public NullModel() {
            super(null, true, new Object[0]);
        }

        public TextureAtlasSprite func_177554_e() {
            return Chameleon.instance.iconRegistry.getIcon(TextureMap.field_174945_f);
        }
    }
}

