/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.GSItems;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGravitationModule
extends TileBaseElectricBlockWithInventory
implements ITileEffects {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public static int processTicks = 0;
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    private int radius = 8;
    private AxisAlignedBB aabb;
    private boolean initialised = true;
    public static boolean check = false;
    public boolean shouldRenderEffects = false;

    public TileEntityGravitationModule() {
        super("tile.gravitation_module.name");
        this.storage.setCapacity(15000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.func_145843_s();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        if (this.canProcess() && !this.disabled) {
            if (this.hasEnoughEnergyToRun) {
                int energy_boost = 0;
                this.radius = 8;
                for (int i = 0; i <= 3; ++i) {
                    if (((ItemStack)this.getInventory().get(1 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 0))) {
                        this.radius += 2;
                    }
                    if (!((ItemStack)this.getInventory().get(1 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                    ++energy_boost;
                }
                this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(150 - 20 * energy_boost) : (float)(130 - 15 * energy_boost));
                if (processTicks == 0) {
                    processTicks = this.processTimeRequired;
                } else if (--processTicks <= 0) {
                    this.smeltItem();
                    processTicks = this.processTimeRequired;
                }
            } else if (processTicks > 0) {
                if (processTicks < this.processTimeRequired) {
                    if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                        ++processTicks;
                    }
                    check = false;
                }
            }
        } else {
            processTicks = 0;
        }
    }

    public static boolean canProcess() {
        return true;
    }

    public void smeltItem() {
        this.aabb = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - this.getGravityRadius()), (double)(this.func_174877_v().func_177956_o() - 4), (double)(this.func_174877_v().func_177952_p() - this.getGravityRadius()), (double)(this.func_174877_v().func_177958_n() + this.getGravityRadius()), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + this.getGravityRadius()));
        if (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider) {
            double g = this.field_145850_b.field_73011_w instanceof WorldProviderSpaceStation ? 0.80665 : (1.0 - (double)((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).getGravity()) / (double)0.08f;
            List list = this.field_145850_b.func_72872_a(Entity.class, this.aabb);
            if (!this.field_145850_b.field_72995_K) {
                for (Object e : list) {
                    if (e instanceof IAntiGrav) continue;
                    Entity entity = (Entity)e;
                    entity.field_70143_R = (float)((double)entity.field_70143_R - g * 10.0);
                    if (e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
                        ((EntityLivingBase)e).field_70181_x -= g / 200.0;
                    }
                    if (!(entity.field_70143_R < 0.0f)) continue;
                    entity.field_70143_R = 0.0f;
                }
            } else {
                for (Object e : list) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase living = (EntityLivingBase)e;
                    if (e instanceof EntityPlayer) {
                        EntityPlayer p = (EntityPlayer)living;
                        if (p.field_71075_bZ.field_75100_b || !p.field_71071_by.func_70440_f(0).func_190926_b() && p.field_71071_by.func_70440_f(0).func_77973_b() instanceof IArmorGravity && ((IArmorGravity)p.field_71071_by.func_70440_f(0).func_77973_b()).gravityOverrideIfLow(p) > 0) continue;
                    }
                    living.field_70181_x -= g / 300.0;
                }
            }
            check = true;
            if (this.shouldRenderEffects && this.field_145850_b.field_72995_K) {
                for (int yy = -4; yy < 16; ++yy) {
                    for (int ix = -this.getGravityRadius(); ix <= this.getGravityRadius() + 1; ++ix) {
                        if (ix != -this.getGravityRadius() && ix != this.getGravityRadius() + 1 && yy != 15 && yy != -4) continue;
                        this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)((float)(this.func_174877_v().func_177958_n() + ix) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177956_o() + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177952_p() - this.getGravityRadius()) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)((float)(this.func_174877_v().func_177958_n() + ix) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177956_o() + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177952_p() + this.getGravityRadius() + 1) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0, new int[0]);
                    }
                    for (int iz = -this.getGravityRadius(); iz <= this.getGravityRadius() + 1; ++iz) {
                        if (iz != -this.getGravityRadius() && iz != this.getGravityRadius() + 1 && yy != 15 && yy != -4) continue;
                        this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)((float)(this.func_174877_v().func_177958_n() - this.getGravityRadius()) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177956_o() + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177952_p() + iz) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)((float)(this.func_174877_v().func_177958_n() + this.getGravityRadius() + 1) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177956_o() + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.func_174877_v().func_177952_p() + iz) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.initialised = this.storage.getEnergyStoredGC() > 16000.0f;
        processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (par1NBTTagCompound.func_74764_b("gravityradius")) {
            int grav = par1NBTTagCompound.func_74762_e("gravityradius");
            this.setGravityRadius(grav == 0 ? 1 : grav);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", processTicks);
        par1NBTTagCompound.func_74768_a("gravityradius", this.radius > 16 ? 16 : this.radius);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        return par1NBTTagCompound;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return true;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public void setEffectsVisible(boolean shouldRender) {
        this.shouldRenderEffects = shouldRender;
    }

    @Override
    public boolean getEffectsVisible() {
        return this.shouldRenderEffects;
    }

    public void setGravityRadius(int radius) {
        this.radius = radius;
    }

    public int getGravityRadius() {
        return this.radius;
    }

    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        return false;
    }

    public boolean inGravityZone(World world, EntityPlayer player) {
        return player.field_70165_t > (double)(this.field_174879_c.func_177958_n() - this.getGravityRadius()) && player.field_70163_u > (double)(this.field_174879_c.func_177956_o() - 4) && player.field_70161_v > (double)(this.field_174879_c.func_177952_p() - this.getGravityRadius()) && player.field_70165_t < (double)(this.field_174879_c.func_177958_n() + this.getGravityRadius()) && player.field_70163_u < (double)(this.field_174879_c.func_177956_o() + 16) && player.field_70161_v < (double)(this.field_174879_c.func_177952_p() + this.getGravityRadius());
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }
}

