/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension;

import asmodeuscore.api.dimension.IProviderFog;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_ChunkProviderSpace;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_OreGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_TerrainGenerator;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.ACentauriSystem.ACentauriSystemBodies;
import galaxyspace.systems.ACentauriSystem.core.registers.blocks.ACBlocks;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.sky.SkyProviderProxima_B;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Beach;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Forest;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Ice_Plains;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Mountains;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Ocean;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.world.gen.we.Proxima_B_Plains;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderProxima_B_WE
extends WE_WorldProviderSpace
implements IProviderFog {
    private final float[] colorsSunriseSunset = new float[4];
    public static WE_ChunkProvider chunk;

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MIN_VALUE;
    }

    public CelestialBody getCelestialBody() {
        return ACentauriSystemBodies.proxima_b;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return WE_ChunkProviderSpace.class;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f = 0.4f;
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.25882354f * f), (double)(0.27450982f * f), (double)(0.3137255f * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.7f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.3137255f * f), (double)(0.3647059f * f), (double)(0.39215687f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public boolean hasSunset() {
        return true;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.1f + 0.1f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)1.0f);
        f2 = 1.2f - f2;
        return f2 * 0.8f;
    }

    public IRenderHandler getCloudRenderer() {
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 180.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderProxima_B());
        }
        return super.getSkyRenderer();
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public DimensionType func_186058_p() {
        return GSDimensions.PROXIMA_B;
    }

    public void genSettings(WE_ChunkProvider cp) {
        chunk = cp;
        cp.createChunkGen_List.clear();
        cp.createChunkGen_InXZ_List.clear();
        cp.createChunkGen_InXYZ_List.clear();
        cp.decorateChunkGen_List.clear();
        WE_Biome.setBiomeMap((WE_ChunkProvider)cp, (double)1.2, (int)4, (double)1400.0, (double)0.675);
        WE_TerrainGenerator terrainGenerator = new WE_TerrainGenerator();
        terrainGenerator.worldStoneBlock = ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(2);
        terrainGenerator.worldSeaGen = true;
        terrainGenerator.worldSeaGenBlock = Blocks.field_150355_j.func_176223_P();
        terrainGenerator.worldSeaGenMaxY = 64;
        cp.createChunkGen_List.add(terrainGenerator);
        WE_CaveGen cg = new WE_CaveGen();
        cg.replaceBlocksList.clear();
        cg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        cp.createChunkGen_List.add(cg);
        WE_RavineGen rg = new WE_RavineGen();
        rg.replaceBlocksList.clear();
        rg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        rg.lavaBlock = Blocks.field_150353_l.func_176223_P();
        cp.createChunkGen_List.add(rg);
        ((WE_ChunkProviderSpace)cp).worldGenerators.clear();
        cp.biomesList.clear();
        WE_OreGen standardOres = new WE_OreGen();
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(1), terrainGenerator.worldStoneBlock, 14, 30, 100, 150);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(5), terrainGenerator.worldStoneBlock, 6, 10, 80, 8);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(6), terrainGenerator.worldStoneBlock, 6, 20, 90, 10);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(7), terrainGenerator.worldStoneBlock, 6, 20, 90, 15);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(8), terrainGenerator.worldStoneBlock, 10, 20, 90, 15);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(9), terrainGenerator.worldStoneBlock, 4, 5, 20, 5);
        standardOres.add(ACBlocks.PROXIMA_B_BLOCKS.func_176203_a(10), terrainGenerator.worldStoneBlock, 4, 3, 15, 4);
        cp.decorateChunkGen_List.add(standardOres);
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Plains());
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Forest(cp));
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Ice_Plains());
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Mountains());
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Ocean());
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new Proxima_B_Beach());
    }

    public float getSolarSize() {
        return 0.3f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public int func_76559_b(long worldTime) {
        return (int)(worldTime / this.getDayLength() % 8L + 8L) % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null) {
            int phase = this.func_76559_b(this.getWorldTime());
            if (sunBrightness > 0.4f && phase != 0 && phase != 6 && !this.field_76579_a.func_72896_J()) {
                colors[1] = colors[1] - skyLight / 1.6f;
                colors[2] = colors[2] - skyLight / 1.6f;
            }
        }
    }

    public int getFogColor(int arg0, int arg1, int arg2) {
        int A = 0xA000000;
        int R = 0x420000;
        int G = 17920;
        int B = 80;
        int color = A + R + G + B;
        return GSUtils.getColor(66, 70, 80, 10);
    }

    public float getFogDensity(int arg0, int arg1, int arg2) {
        switch (this.func_76559_b(this.getWorldTime())) {
            case 0: {
                return 0.45f;
            }
            case 1: {
                return 0.95f;
            }
            case 3: {
                return 0.85f;
            }
            case 5: {
                return 0.6f;
            }
            case 6: {
                return 0.3f;
            }
        }
        return 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        if (this.field_76579_a == null) {
            return solarMultiplier;
        }
        switch (this.func_76559_b(this.getWorldTime())) {
            case 0: {
                return solarMultiplier * (double)0.35f;
            }
            case 1: {
                return solarMultiplier * (double)0.95f;
            }
            case 3: {
                return solarMultiplier * (double)0.95f;
            }
            case 5: {
                return solarMultiplier * 0.5;
            }
            case 6: {
                return solarMultiplier * (double)0.2f;
            }
        }
        return solarMultiplier;
    }

    public boolean enableAdvancedThermalLevel() {
        return true;
    }

    public void onPopulate(int cX, int cZ) {
    }

    public void onChunkProvider(int cX, int cZ, ChunkPrimer primer) {
    }

    public void recreateStructures(Chunk chunkIn, int x, int z) {
    }
}

