/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.task;

import com.google.common.base.Preconditions;
import com.mcsimonflash.sponge.cmdscheduler.schedule.ClassicSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.CronSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.Tristate;

public class ScheduledTask {
    private final String name;
    private final Consumer<ScheduledTask> executor;
    private final Schedule schedule;
    private final Tristate async;
    private Task task;

    private ScheduledTask(String name, Consumer<ScheduledTask> executor, Schedule schedule, Tristate async) {
        this.name = name;
        this.executor = executor;
        this.schedule = schedule;
        this.async = async;
    }

    public void start(PluginContainer container) {
        if (this.task == null) {
            Task.Builder builder = Task.builder();
            long delay = this.schedule.getDelay();
            if (delay < 0L) {
                return;
            }
            if (this.schedule instanceof ClassicSchedule && ((ClassicSchedule)this.schedule).isDelayTicks()) {
                builder.delayTicks(delay);
            } else {
                builder.delay(delay, TimeUnit.MILLISECONDS);
            }
            long interval = this.schedule.getInterval();
            if (interval > 0L) {
                if (this.schedule instanceof ClassicSchedule && ((ClassicSchedule)this.schedule).isIntervalTicks()) {
                    builder.intervalTicks(interval);
                } else {
                    builder.interval(interval, TimeUnit.MILLISECONDS);
                }
            }
            Consumer<Task> consumer = st -> this.execute(container);
            switch (this.async) {
                case UNDEFINED: {
                    consumer = st -> Task.builder().name("CmdTask Synchronous Wrapper: " + this.name).execute(t -> this.execute(container)).submit((Object)container);
                }
                case TRUE: {
                    builder.async();
                }
            }
            if (this.schedule instanceof CronSchedule) {
                Consumer<Task> copy = consumer;
                consumer = st -> {
                    copy.accept((Task)st);
                    if (this.task != null) {
                        this.task.cancel();
                        this.task = null;
                        Task.builder().delayTicks(0L).execute(t -> this.start(container)).submit((Object)container);
                    }
                };
            }
            this.task = builder.name(this.name).execute(consumer).submit((Object)container);
        }
    }

    public void stop(PluginContainer container) {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void execute(PluginContainer container) {
        try {
            this.executor.accept(this);
        }
        catch (Throwable t) {
            container.getLogger().error("An error occurred attempting to execute a CmdTask for this plugin.", t);
        }
    }

    public String getName() {
        return this.name;
    }

    public Consumer<ScheduledTask> getExecutor() {
        return this.executor;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Tristate getAsync() {
        return this.async;
    }

    public boolean isActive() {
        return this.isRunning();
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public String toString() {
        return "ScheduledTask{name=" + this.name + ",schedule=" + this.schedule + ",async=" + this.async.toString().toLowerCase() + ", active=" + this.isActive() + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ResettableBuilder<ScheduledTask, Builder> {
        @Nullable
        private String name;
        @Nullable
        private Consumer<ScheduledTask> executor;
        @Nullable
        private Schedule schedule;
        private Tristate async = Tristate.UNDEFINED;

        public Builder from(ScheduledTask value) {
            this.executor = value.getExecutor();
            this.schedule = value.getSchedule();
            this.async = value.getAsync();
            return this;
        }

        public Builder reset() {
            this.name = null;
            this.executor = null;
            this.schedule = null;
            this.async = Tristate.UNDEFINED;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder executor(Consumer<ScheduledTask> executor) {
            this.executor = executor;
            return this;
        }

        public Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder async(Tristate async) {
            this.async = async;
            return this;
        }

        public ScheduledTask build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"Name must be defined.");
            Preconditions.checkArgument((this.executor != null ? 1 : 0) != 0, (Object)"Executor must be defined.");
            Preconditions.checkArgument((this.schedule != null ? 1 : 0) != 0, (Object)"Schedule must be defined.");
            return new ScheduledTask(this.name, this.executor, this.schedule, this.async);
        }
    }
}

