/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.schedule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.stream.IntStream;

public enum Units {
    MONTHS(2, 1, 12),
    DAYS(5, 1, 31),
    HOURS(11, 0, 23),
    MINUTES(12, 0, 59),
    SECONDS(13, 0, 59),
    MILLISECONDS(14, 0, 999);

    public final int constant;
    public final int lower;
    public final int upper;
    public final ImmutableSortedSet<Integer> values;

    private Units(int constant, int lower, int upper) {
        this.constant = constant;
        this.lower = lower;
        this.upper = upper;
        this.values = ImmutableSortedSet.copyOf((Comparable[])((Comparable[])IntStream.rangeClosed(lower, upper).boxed().toArray(Integer[]::new)));
    }

    public int checkBounds(int number) throws IllegalArgumentException {
        Preconditions.checkArgument((this.lower <= number && number <= this.upper ? 1 : 0) != 0, (Object)("Number '" + number + "' is out of range. | Range:[" + this.lower + "-" + this.upper + "] Unit:[" + this.name() + "]"));
        return number;
    }
}

