/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.internal;

import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.ConfigHolder;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.NodeUtils;
import com.mcsimonflash.sponge.cmdscheduler.CmdScheduler;
import com.mcsimonflash.sponge.cmdscheduler.internal.Utils;
import com.mcsimonflash.sponge.cmdscheduler.schedule.CalendarSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.ClassicSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.CronSchedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Units;
import com.mcsimonflash.sponge.cmdscheduler.task.CommandTask;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.util.Tristate;

public class Config {
    private static Path directory = CmdScheduler.get().getDirectory();
    private static Path configuration = directory.resolve("configuration");
    private static ConfigHolder<CommentedConfigurationNode> config;
    public static Map<String, CommandTask> tasks;

    public static void load() {
        tasks.values().forEach(t -> t.getTask().stop(CmdScheduler.get().getContainer()));
        tasks.clear();
        try {
            Files.createDirectories(configuration, new FileAttribute[0]);
            if (Files.notExists(configuration.resolve("tasks.conf"), new LinkOption[0])) {
                ((Asset)CmdScheduler.get().getContainer().getAsset("tasks.conf").get()).copyToDirectory(configuration);
            }
            config = ConfigHolder.of((ConfigurationLoader)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configuration.resolve("tasks.conf"))).build());
            ((CommentedConfigurationNode)config.getNode(new Object[0])).getChildrenMap().values().forEach(Config::loadTask);
        }
        catch (IOException e) {
            CmdScheduler.get().getLogger().error("An unexpected error occurred loading the config: ", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void loadTask(ConfigurationNode node) {
        try {
            String name = (String)node.getKey();
            List<String> commands = node.getNode(new Object[]{"commands"}).getChildrenList().stream().map(n -> n.getString("").startsWith("/") ? n.getString("").substring(1) : n.getString("")).collect(Collectors.toList());
            NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{"command"}), n -> {
                CmdScheduler.get().getLogger().warn("Task " + name + " has a command node defined, use the commands list instead (v1.1.1)");
                commands.add(n.getString("").startsWith("/") ? n.getString("").substring(1) : n.getString(""));
            });
            Schedule schedule = Config.getSchedule(node.getNode(new Object[]{"schedule"}));
            Tristate async = node.getNode(new Object[]{"async"}).isVirtual() ? Tristate.UNDEFINED : Tristate.fromBoolean((boolean)node.getNode(new Object[]{"async"}).getBoolean(false));
            tasks.put(name.toLowerCase(), new CommandTask(name, commands, schedule, async));
        }
        catch (IllegalArgumentException e) {
            CmdScheduler.get().getLogger().error(e.getMessage());
        }
    }

    private static Schedule getSchedule(ConfigurationNode node) throws IllegalArgumentException {
        switch (node.getNode(new Object[]{"type"}).getString("").toLowerCase()) {
            case "calendar": {
                return CalendarSchedule.builder().date(node.getNode(new Object[]{"date"}).getString("")).interval(Utils.parseTime(node.getNode(new Object[]{"interval"}).getString(""))).build();
            }
            case "classic": {
                ClassicSchedule.Builder classic = ClassicSchedule.builder();
                NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{"delay"}), n -> classic.delay(Utils.parseTime(n.getString("0"))));
                NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{"delay-ticks"}), n -> classic.delayTicks(n.getLong(0L)));
                NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{"interval"}), n -> classic.interval(Utils.parseTime(n.getString(""))));
                NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{"interval-ticks"}), n -> n.getLong(0L));
                return classic.build();
            }
            case "cron": {
                CronSchedule.Builder cron = CronSchedule.builder();
                if (!node.getNode(new Object[]{"schedule"}).isVirtual()) {
                    cron.schedule(node.getNode(new Object[]{"schedule"}).getString(""));
                } else {
                    for (Units unit : Units.values()) {
                        NodeUtils.ifAttached((ConfigurationNode)node.getNode(new Object[]{unit.name().toLowerCase()}), n -> n.getString(""));
                    }
                }
                return cron.build();
            }
        }
        throw new IllegalArgumentException("Unknown schedule type " + node.getNode(new Object[]{"type"}).getString("undefined"));
    }

    static {
        tasks = Maps.newHashMap();
    }
}

