/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items.urantypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.Registry;

public class Uranium233
extends UranBaseType {
    public Uranium233() {
        this.addArray(new int[]{-1, -1});
        this.addArray(new int[]{0, -1});
        this.addArray(new int[]{1, -1});
        this.addArray(new int[]{-1, 0});
        this.addArray(new int[]{1, 0});
        this.addArray(new int[]{-1, 1});
        this.addArray(new int[]{0, 1});
        this.addArray(new int[]{1, 1});
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(IUranium.RodType type) {
        return Ic2Icons.getTextures((String)"ic2c_extras_nuclear_cells")[this.getTextureID(type)];
    }

    public int getRow() {
        return 0;
    }

    public int getMaxDurability() {
        return 12000;
    }

    public float getEUPerPulse() {
        return 0.5f;
    }

    public int getPulsesPerTick() {
        return 2;
    }

    public int getPulsesForConnection() {
        return 1;
    }

    public float getHeatModifier() {
        return 0.8f;
    }

    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    public ItemStack getUraniumIngot() {
        return new ItemStack((Item)Registry.uranium233Ingot);
    }

    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return new ItemStack((Item)Registry.singleUranium233Cell).func_77946_l();
            }
            case DualRod: {
                return new ItemStack((Item)Registry.doubleUranium233Cell).func_77946_l();
            }
            case QuadRod: {
                return new ItemStack((Item)Registry.quadUranium233Cell).func_77946_l();
            }
            case NearDepletedRod: {
                return new ItemStack((Item)Registry.nearDepletedUranium233Cell).func_77946_l();
            }
            case IsotopicRod: {
                return new ItemStack((Item)Registry.isotopicUranium233Cell).func_77946_l();
            }
            case ReEnrichedRod: {
                return new ItemStack((Item)Registry.reEnrichedUranium233Cell).func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage((ItemStack)this.getRodType(IUranium.RodType.IsotopicRod), (int)(this.getMaxDurability() - 1));
    }

    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 1124;
            }
            case DualRod: {
                return 1125;
            }
            case QuadRod: {
                return 1126;
            }
            case ReEnrichedRod: {
                return 1127;
            }
            case NearDepletedRod: {
                return 1128;
            }
            case IsotopicRod: {
                return 1129;
            }
        }
        return 0;
    }

    public short getTextureID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 16;
            }
            case DualRod: {
                return 10;
            }
            case QuadRod: {
                return 4;
            }
            case ReEnrichedRod: {
                return 34;
            }
            case NearDepletedRod: {
                return 22;
            }
            case IsotopicRod: {
                return 28;
            }
        }
        return 0;
    }

    public LocaleComp getName(IUranium.RodType rodType) {
        return Ic2Lang.nullKey;
    }

    public boolean isReEnrichedUran() {
        return false;
    }

    public Color getReEnrichedColor() {
        return null;
    }

    public ItemStack getIngridient() {
        return null;
    }

    public int getIngrientPoints() {
        return 0;
    }

    public int getIngridientCost() {
        return 0;
    }
}

