/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.interfaces;

import com.google.inject.ImplementedBy;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.MessageProviderService;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.ConfigFileMessagesRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.IMessageRepository;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

@ImplementedBy(value=MessageProviderService.class)
public interface IMessageProviderService {
    public boolean hasKey(String var1);

    public Locale getDefaultLocale();

    public void invalidateLocaleCacheFor(UUID var1);

    public Optional<Locale> getLocaleFromName(String var1);

    public Locale getLocaleFor(CommandSource var1);

    public Text getMessageFor(Locale var1, String var2);

    public Text getMessageFor(Locale var1, String var2, Text ... var3);

    public Text getMessageFor(Locale var1, String var2, Object ... var3);

    public Text getMessageFor(Locale var1, String var2, String ... var3);

    public String getMessageString(Locale var1, String var2, String ... var3);

    public String getMessageString(Locale var1, String var2, Object ... var3);

    default public Text getMessageForDefault(String key, Text ... args) {
        return this.getMessageFor(this.getDefaultLocale(), key, args);
    }

    default public Text getMessageFor(CommandSource source, String key) {
        return this.getMessageFor(this.getLocaleFor(source), key);
    }

    default public Text getMessageFor(CommandSource source, String key, Text ... args) {
        return this.getMessageFor(this.getLocaleFor(source), key, args);
    }

    default public Text getMessageFor(CommandSource source, String key, String ... args) {
        Text[] t = (Text[])Arrays.stream(args).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).toArray(Text[]::new);
        return this.getMessageFor(this.getLocaleFor(source), key, t);
    }

    default public Text getMessage(String key) {
        return this.getMessageForDefault(key, new Text[0]);
    }

    default public Text getMessage(String key, String ... replacements) {
        return this.getMessageFor(this.getDefaultLocale(), key, replacements);
    }

    default public Text getMessage(String key, Text ... replacements) {
        return this.getMessageFor(this.getDefaultLocale(), key, replacements);
    }

    default public Text getMessage(String key, Object ... replacements) {
        return this.getMessageFor(this.getDefaultLocale(), key, replacements);
    }

    default public String getMessageString(String key, Object ... replacements) {
        return this.getMessageString(this.getDefaultLocale(), key, replacements);
    }

    default public String getMessageString(CommandSource source, String key, String ... replacements) {
        return this.getMessageString(this.getLocaleFor(source), key, replacements);
    }

    default public Text getMessageFor(CommandSource source, String key, Object ... replacements) {
        return this.getMessageFor(this.getLocaleFor(source), key, replacements);
    }

    default public void sendMessageTo(CommandSource receiver, String key) {
        receiver.sendMessage(this.getMessageFor(this.getLocaleFor(receiver), key));
    }

    default public void sendMessageTo(MessageReceiver receiver, String key, Object ... replacements) {
        if (receiver instanceof CommandSource) {
            receiver.sendMessage(this.getMessageFor(this.getLocaleFor((CommandSource)receiver), key, replacements));
        } else {
            receiver.sendMessage(this.getMessageFor((CommandSource)Sponge.getServer().getConsole(), key, replacements));
        }
    }

    default public void sendMessageTo(CommandSource receiver, String key, Object ... replacements) {
        receiver.sendMessage(this.getMessageFor(this.getLocaleFor(receiver), key, replacements));
    }

    default public void sendMessageTo(CommandSource receiver, String key, Text ... replacements) {
        receiver.sendMessage(this.getMessageFor(this.getLocaleFor(receiver), key, replacements));
    }

    default public void sendMessageTo(CommandSource receiver, String key, String ... replacements) {
        receiver.sendMessage(this.getMessageFor(this.getLocaleFor(receiver), key, replacements));
    }

    default public void sendMessageTo(Supplier<CommandSource> receiver, String key, String ... replacements) {
        this.sendMessageTo(receiver.get(), key, replacements);
    }

    default public void sendMessageTo(Supplier<CommandSource> receiver, String key, Object ... replacements) {
        this.sendMessageTo(receiver.get(), key, replacements);
    }

    public boolean reloadMessageFile();

    public IMessageRepository getMessagesRepository(Locale var1);

    public ConfigFileMessagesRepository getConfigFileMessageRepository();

    default public String getTimeToNow(Locale locale, Instant instant) {
        return this.getTimeString(locale, Instant.now().getEpochSecond() - instant.getEpochSecond());
    }

    public String getTimeString(Locale var1, Duration var2);

    public String getTimeString(Locale var1, long var2);

    public List<String> getAllLocaleNames();
}

