/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.IMessageRepository;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.translation.Translatable;

abstract class AbstractMessageRepository
implements IMessageRepository {
    private static final Pattern STRING_REPLACER = Pattern.compile("\\{+[^0-9]+}+");
    private static final Pattern STRING_LOCALISER = Pattern.compile("loc:([a-z\\-.]+)");
    final Map<String, String> cachedStringMessages = new HashMap<String, String>();
    final Map<String, TextTemplate> cachedMessages = new HashMap<String, TextTemplate>();
    private final IPlayerDisplayNameService playerDisplayNameService;
    private final ITextStyleService textStyleService;

    AbstractMessageRepository(ITextStyleService textStyleService, IPlayerDisplayNameService playerDisplayNameService) {
        this.textStyleService = textStyleService;
        this.playerDisplayNameService = playerDisplayNameService;
    }

    abstract String getEntry(String var1);

    private String getStringEntry(String key) {
        return STRING_REPLACER.matcher(this.getEntry(key).replaceAll("'", "''")).replaceAll("'$0'");
    }

    private TextTemplate getTextTemplate(String key) {
        return this.cachedMessages.computeIfAbsent(key, k -> this.templateCreator(this.getEntry((String)k)));
    }

    @Override
    public Text getText(String key) {
        return this.cachedMessages.computeIfAbsent(key, this::getTextTemplate).toText();
    }

    @Override
    public Text getText(String key, Object[] args) {
        return this.getTextMessageWithTextFormat(key, Arrays.stream(args).map(x -> {
            if (x instanceof User) {
                return this.playerDisplayNameService.getDisplayName(((User)x).getUniqueId());
            }
            if (x instanceof TextRepresentable) {
                return (TextRepresentable)x;
            }
            if (x instanceof Translatable) {
                return Text.of((Object[])new Object[]{x});
            }
            if (x instanceof String) {
                String s = (String)x;
                Matcher matcher = STRING_LOCALISER.matcher(s);
                if (matcher.matches()) {
                    return this.getText(matcher.group(1));
                }
                return Text.of((Object[])new Object[]{x});
            }
            return Text.of((String)x.toString());
        }).collect(Collectors.toList()));
    }

    @Override
    public String getString(String key) {
        return this.cachedStringMessages.computeIfAbsent(key, this::getStringEntry);
    }

    @Override
    public String getString(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    private Text getTextMessageWithTextFormat(String key, List<? extends TextRepresentable> textList) {
        TextTemplate template = this.getTextTemplate(key);
        if (textList.isEmpty()) {
            return template.toText();
        }
        HashMap objs = Maps.newHashMap();
        for (int i = 0; i < textList.size(); ++i) {
            objs.put(String.valueOf(i), textList.get(i));
        }
        return template.apply((Map)objs).build();
    }

    final TextTemplate templateCreator(String string) {
        Matcher mat = Pattern.compile("\\{([\\d]+)}").matcher(string);
        ArrayList map = Lists.newArrayList();
        while (mat.find()) {
            map.add(Integer.parseInt(mat.group(1)));
        }
        String[] s = string.split("\\{([\\d]+)}");
        ArrayList objects = Lists.newArrayList();
        Text t = this.textStyleService.oldLegacy(s[0]);
        ITextStyleService.TextFormat tuple = this.textStyleService.getLastColourAndStyle((TextRepresentable)t, null);
        objects.add(t);
        int count = 1;
        for (Integer x : map) {
            objects.add(TextTemplate.arg((String)x.toString()).optional().color(tuple.colour()).style(tuple.style()).build());
            if (s.length > count) {
                t = Text.of((Object[])new Object[]{tuple.colour(), tuple.style(), this.textStyleService.oldLegacy(s[count])});
                tuple = this.textStyleService.getLastColourAndStyle((TextRepresentable)t, null);
                objects.add(t);
            }
            ++count;
        }
        return TextTemplate.of((Object[])objects.toArray(new Object[0]));
    }
}

