/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.configurate;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import com.google.inject.Injector;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.InstantTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.LocaleSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.MailMessageSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NamedLocationSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NucleusItemStackSnapshotSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NucleusTextTemplateTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.Vector3dTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.WarpCategorySerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.WarpSerialiser;
import io.github.nucleuspowered.nucleus.configurate.wrappers.NucleusItemStackSnapshot;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.DataObjectTranslator;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.configurate.AbstractConfigurateBackedDataObject;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.IConfigurateHelper;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.util.PrettyPrinter;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import io.github.nucleuspowered.relocate.nucleus.neutrino.objectmapper.NeutrinoObjectMapperFactory;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessor;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.ByteArrayTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.IntArrayTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.PatternTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.SetTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.ShortArrayTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.util.ClassConstructor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Singleton
public class ConfigurateHelper
implements IConfigurateHelper {
    private final IMessageProviderService messageProvider;
    private static final TypeToken<AbstractConfigurateBackedDataObject> ABSTRACT_DATA_OBJECT_TYPE_TOKEN = TypeToken.of(AbstractConfigurateBackedDataObject.class);
    private final TypeSerializerCollection typeSerializerCollection;
    private final NeutrinoObjectMapperFactory objectMapperFactory;
    private final Pattern commentPattern = Pattern.compile("^(loc:)?(?<key>([a-zA-Z0-9_-]+\\.?)+)$");
    private static final String CWBAH_OBJECT_MAPPER = "cz.neumimto.config.blackjack.and.hookers.NotSoStupidObjectMapper";
    private static final String CWBAH_TYPE_SERIALIZER = "cz.neumimto.config.blackjack.and.hookers.ClassTypeNodeSerializer";
    private static final String ANNOTATED_OBJECT_SERIALIZER = "ninja.leaping.configurate.objectmapping.serialize.AnnotatedObjectSerializer";

    @Inject
    public ConfigurateHelper(INucleusServiceCollection serviceCollection) {
        this.messageProvider = serviceCollection.messageProvider();
        this.objectMapperFactory = NeutrinoObjectMapperFactory.builder().setCommentProcessor(setting -> {
            Matcher matcher;
            String comment = setting.comment();
            if (comment.contains(".") && !comment.contains(" ") && (matcher = this.commentPattern.matcher(comment)).matches()) {
                return this.messageProvider.getMessageString(matcher.group("key"), new Object[0]);
            }
            return comment;
        }).setSettingProcessorClassConstructor(new SettingProcessorConstructor(serviceCollection.injector())).build(true);
        this.typeSerializerCollection = ConfigurateHelper.setup(serviceCollection);
    }

    @Override
    public ConfigurationOptions setOptions(ConfigurationOptions options) {
        return options.withSerializers(this.typeSerializerCollection).setObjectMapperFactory((ObjectMapperFactory)this.objectMapperFactory);
    }

    private static TypeSerializerCollection setup(INucleusServiceCollection serviceCollection) {
        TypeSerializerCollection typeSerializerCollection = ConfigurationOptions.defaults().getSerializers().newChild();
        typeSerializerCollection.register(TypeToken.of(Vector3d.class), (TypeSerializer)new Vector3dTypeSerialiser());
        typeSerializerCollection.register(TypeToken.of(NucleusItemStackSnapshot.class), (TypeSerializer)new NucleusItemStackSnapshotSerialiser(serviceCollection));
        typeSerializerCollection.register(TypeToken.of(Pattern.class), (TypeSerializer)new PatternTypeSerialiser());
        typeSerializerCollection.register(TypeToken.of(NucleusTextTemplateImpl.class), (TypeSerializer)new NucleusTextTemplateTypeSerialiser(serviceCollection.textTemplateFactory()));
        typeSerializerCollection.register(typeToken -> Set.class.isAssignableFrom(typeToken.getRawType()), (TypeSerializer)new SetTypeSerialiser());
        typeSerializerCollection.register((TypeToken)new TypeToken<byte[]>(){}, (TypeSerializer)new ByteArrayTypeSerialiser());
        typeSerializerCollection.register((TypeToken)new TypeToken<short[]>(){}, (TypeSerializer)new ShortArrayTypeSerialiser());
        typeSerializerCollection.register((TypeToken)new TypeToken<int[]>(){}, (TypeSerializer)new IntArrayTypeSerialiser());
        typeSerializerCollection.register(TypeToken.of(Instant.class), (TypeSerializer)new InstantTypeSerialiser());
        typeSerializerCollection.register(x -> x.isSubtypeOf(ABSTRACT_DATA_OBJECT_TYPE_TOKEN), (TypeSerializer)DataObjectTranslator.INSTANCE);
        typeSerializerCollection.register(TypeTokens.WARP, (TypeSerializer)new WarpSerialiser(serviceCollection.logger()));
        typeSerializerCollection.register(TypeTokens.WARP_CATEGORY, (TypeSerializer)new WarpCategorySerialiser());
        typeSerializerCollection.register(TypeTokens.NAMEDLOCATION, (TypeSerializer)new NamedLocationSerialiser(serviceCollection.logger()));
        typeSerializerCollection.register(TypeTokens.MAIL_MESSAGE, (TypeSerializer)new MailMessageSerialiser());
        typeSerializerCollection.register(TypeTokens.LOCALE, (TypeSerializer)new LocaleSerialiser());
        ConfigurateHelper.fixGrossHacks(serviceCollection.logger(), typeSerializerCollection);
        return typeSerializerCollection;
    }

    private static void fixGrossHacks(Logger logger, TypeSerializerCollection collection) {
        try {
            Class.forName(CWBAH_OBJECT_MAPPER);
            TypeSerializer serializer = TypeSerializers.getDefaultSerializers().get(TypeToken.of(DummyConfigSerializable.class));
            if (serializer.getClass().getName().equalsIgnoreCase(CWBAH_TYPE_SERIALIZER)) {
                new PrettyPrinter(100).add("ConfigurateButWithBlackjackAndHookers has been detected.").hr().add("Some plugins, such as NT-RPG, use a gross hack to inject their object mapper into").add("Configurate instead of using the supported way. This system is known as").add("ConfigurateButWithBlackjackAndHookers. Because of the hack, Nucleus cannot use its").add("own extensions which use standard Configurate API.").add().add("We will attempt to work around this by restoring the Configurate code for our type").add("serialisers only - this will only work for Nucleus. Other plugins may be broken by").add("ConfigurateButWithBlackjackAndHookers.").add().add("We have reported this issue to the author.").log(logger, Level.WARN);
                try {
                    Class<?> clazz = Class.forName(ANNOTATED_OBJECT_SERIALIZER);
                    Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    TypeSerializer ts = (TypeSerializer)ctor.newInstance(new Object[0]);
                    collection.registerPredicate(input -> input.getRawType().isAnnotationPresent(ConfigSerializable.class), ts);
                }
                catch (Exception e) {
                    logger.error("Could not get standard Configurate serialiser. Using our own.");
                    collection.registerPredicate(input -> input.getRawType().isAnnotationPresent(ConfigSerializable.class), (TypeSerializer)new AnnotatedObjectSerializer());
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class SettingProcessorConstructor
    implements ClassConstructor<SettingProcessor> {
        private final Injector injector;

        private SettingProcessorConstructor(Injector injector) {
            this.injector = injector;
        }

        @Override
        public <T extends SettingProcessor> T construct(Class<T> aClass) throws Throwable {
            return (T)((SettingProcessor)this.injector.getInstance(aClass));
        }
    }

    @ConfigSerializable
    private static class DummyConfigSerializable {
        private DummyConfigSerializable() {
        }
    }

    private static class AnnotatedObjectSerializer
    implements TypeSerializer<Object> {
        public static final String CLASS_KEY = "__class__";

        private AnnotatedObjectSerializer() {
        }

        public Object deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
            TypeToken<?> clazz = this.getInstantiableType(type, value.getNode(new Object[]{CLASS_KEY}).getString());
            return value.getOptions().getObjectMapperFactory().getMapper(clazz.getRawType()).bindToNew().populate(value);
        }

        private TypeToken<?> getInstantiableType(TypeToken<?> type, String configuredName) throws ObjectMappingException {
            TypeToken retClass;
            Class rawType = type.getRawType();
            if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
                if (configuredName == null) {
                    throw new ObjectMappingException("No available configured type for instances of " + type);
                }
                try {
                    retClass = TypeToken.of(Class.forName(configuredName));
                }
                catch (ClassNotFoundException e) {
                    throw new ObjectMappingException("Unknown class of object " + configuredName, (Throwable)e);
                }
                if (!retClass.isSubtypeOf(type)) {
                    throw new ObjectMappingException("Configured type " + configuredName + " does not extend " + rawType.getCanonicalName());
                }
            } else {
                retClass = type;
            }
            return retClass;
        }

        public void serialize(@NonNull TypeToken<?> type, @Nullable Object obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
            ObjectMapper mapper;
            if (obj == null) {
                ConfigurationNode clazz = value.getNode(new Object[]{CLASS_KEY});
                value.setValue(null);
                if (!clazz.isVirtual()) {
                    value.getNode(new Object[]{CLASS_KEY}).setValue((Object)clazz);
                }
                return;
            }
            Class rawType = type.getRawType();
            if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
                value.getNode(new Object[]{CLASS_KEY}).setValue((Object)obj.getClass().getName());
                mapper = value.getOptions().getObjectMapperFactory().getMapper(obj.getClass());
            } else {
                mapper = value.getOptions().getObjectMapperFactory().getMapper(type.getRawType());
            }
            mapper.bind(obj).serialize(value);
        }
    }
}

