/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.warp.WarpPermissions;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"list", "#warps"}, basePermission={"nucleus.warp.list.base"}, commandDescriptionKey="warp.list", async=true, parentCommand=WarpCommand.class, associatedPermissions={"nucleus.warps"})
public class ListWarpCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private boolean isDescriptionInList = true;
    private double defaultCost = 0.0;
    private String defaultName = "unknown";
    private boolean isSeparatePerms = true;
    private boolean isCategorise = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"u"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WarpService service = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        if (service.getWarpNames().isEmpty()) {
            return context.errorResult("command.warps.list.nowarps", new Object[0]);
        }
        return !context.hasAny("u") && this.isCategorise ? this.categories(service, context) : this.noCategories(service, context);
    }

    private boolean canView(ICommandContext<? extends CommandSource> context, String warp) {
        return !this.isSeparatePerms || context.testPermission(WarpPermissions.getWarpPermission(warp));
    }

    private ICommandResult categories(WarpService service, ICommandContext<? extends CommandSource> context) {
        Map<WarpCategory, List<Warp>> warps = service.getWarpsWithCategories(x -> this.canView(context, x.getName()));
        this.createMain(context, warps);
        return context.successResult();
    }

    private void createMain(ICommandContext<? extends CommandSource> context, Map<WarpCategory, List<Warp>> warps) {
        List lt = warps.keySet().stream().filter(Objects::nonNull).sorted(Comparator.comparing(WarpCategory::getId)).map(s -> {
            LiteralText.Builder t = Text.builder((String)"> ").color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).append(new Text[]{s.getDisplayName()}).onClick((ClickAction)TextActions.executeCallback(source -> this.createSub(context, (WarpCategory)s, warps)));
            s.getDescription().ifPresent(arg_0 -> ListWarpCommand.lambda$null$2((Text.Builder)t, arg_0));
            return t.build();
        }).collect(Collectors.toList());
        if (warps.containsKey(null)) {
            lt.add(Text.builder((String)("> " + this.defaultName)).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.executeCallback(source -> this.createSub(context, null, warps))).build());
        }
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).header(context.getMessage("command.warps.list.headercategory", new Object[0])).title(context.getMessage("command.warps.list.maincategory", new Object[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
    }

    private void createSub(ICommandContext<? extends CommandSource> context, @Nullable WarpCategory category, Map<WarpCategory, List<Warp>> warpDataList) {
        boolean econExists = context.getServiceCollection().economyServiceProvider().serviceExists();
        Text name = category == null ? Text.of((String)this.defaultName) : category.getDisplayName();
        List lt = warpDataList.get(category).stream().sorted(Comparator.comparing(NamedLocation::getName)).map(s -> this.createWarp((Warp)s, s.getName(), econExists, this.defaultCost, context)).collect(Collectors.toList());
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).title(context.getMessage("command.warps.list.category", name)).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).footer(context.getMessage("command.warps.list.back", new Object[0]).toBuilder().onClick((ClickAction)TextActions.executeCallback(s -> this.createMain(context, warpDataList))).build()).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
    }

    private ICommandResult noCategories(WarpService service, ICommandContext<? extends CommandSource> context) {
        Set<String> ws = service.getWarpNames();
        boolean econExists = context.getServiceCollection().economyServiceProvider().serviceExists();
        List lt = ws.stream().filter(s -> this.canView(context, s.toLowerCase())).sorted(String::compareTo).map(s -> {
            Optional<Warp> wd = service.getWarp((String)s);
            return this.createWarp(wd.orElse(null), (String)s, econExists, this.defaultCost, context);
        }).collect(Collectors.toList());
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).title(context.getMessage("command.warps.list.header", new Object[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
        return context.successResult();
    }

    private Text createWarp(@Nullable Warp data, String name, boolean econExists, double defaultCost, ICommandContext<? extends CommandSource> context) {
        Text.Builder tb;
        if (data == null || !data.getWorldProperties().map(WorldProperties::isEnabled).orElse(false).booleanValue()) {
            return Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.warps.unavailable", new Object[0]))).build();
        }
        String pos = data.getLocation().map(Location::getBlockPosition).orElseGet(() -> data.getPosition().toInt()).toString();
        String worldName = data.getWorldProperties().get().getWorldName();
        LiteralText.Builder inner = Text.builder((String)name).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.runCommand((String)("/warp \"" + name + "\"")));
        Optional<Text> description = data.getDescription();
        if (this.isDescriptionInList) {
            double cost;
            Text.Builder hoverBuilder = Text.builder().append(new Text[]{context.getMessage("command.warps.warpprompt", name)}).append(new Text[]{Text.NEW_LINE}).append(new Text[]{context.getMessage("command.warps.warplochover", worldName, pos)});
            if (econExists && (cost = data.getCost().orElse(defaultCost).doubleValue()) > 0.0) {
                hoverBuilder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{context.getMessage("command.warps.list.costhover", context.getServiceCollection().economyServiceProvider().getCurrencySymbol(cost))});
            }
            tb = Text.builder().append(new Text[]{inner.onHover((HoverAction)TextActions.showText((Text)hoverBuilder.build())).build()});
            description.ifPresent(text -> tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, " - "})}).append(new Text[]{text}));
        } else {
            double cost;
            if (description.isPresent()) {
                inner.onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{context.getMessage("command.warps.warpprompt", name), Text.NEW_LINE, description.get()})));
            } else {
                inner.onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.warps.warpprompt", name)));
            }
            tb = Text.builder().append(new Text[]{inner.build()}).append(new Text[]{context.getMessage("command.warps.warploc", worldName, pos)});
            if (econExists && (cost = data.getCost().orElse(defaultCost).doubleValue()) > 0.0) {
                tb.append(new Text[]{context.getMessage("command.warps.list.cost", context.getServiceCollection().economyServiceProvider().getCurrencySymbol(cost))});
            }
        }
        return tb.build();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        WarpConfig warpConfig = serviceCollection.moduleDataProvider().getModuleConfig(WarpConfig.class);
        this.defaultName = warpConfig.getDefaultName();
        this.defaultCost = warpConfig.getDefaultWarpCost();
        this.isDescriptionInList = warpConfig.isDescriptionInList();
        this.isCategorise = warpConfig.isCategoriseWarps();
        this.isSeparatePerms = warpConfig.isSeparatePermissions();
    }

    private static /* synthetic */ void lambda$null$2(Text.Builder t, Text x) {
        t.append(new Text[]{Text.of((String)" - ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.RESET, TextStyles.NONE, x})});
    }
}

