/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.command;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"command", "commands"}, basePermission={"nucleus.kit.command.base"}, commandDescriptionKey="kit.command", async=true, parentCommand=KitCommand.class)
public class KitCommandCommand
implements ICommandExecutor<CommandSource> {
    private final Text removeIcon = Text.of((Object[])new Object[]{TextColors.WHITE, "[", TextColors.DARK_RED, "X", TextColors.WHITE, "]"});

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(KitService.class).createKitElement(true)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Kit kit = context.requireOne("kit", Kit.class);
        List<String> commands = kit.getCommands();
        if (commands.isEmpty()) {
            context.sendMessage("command.kit.command.nocommands", kit.getName());
        } else {
            ArrayList cc = Lists.newArrayList();
            for (int i = 0; i < commands.size(); ++i) {
                Text t = context.getMessage("command.kit.command.commands.entry", i + 1, commands.get(i));
                if (context.testPermission("nucleus.kit.command.remove.base")) {
                    t = Text.of((Object[])new Object[]{Text.builder().append(new Text[]{this.removeIcon}).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit command remove " + kit.getName() + " " + commands.get(i)))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.command.removehover", new Object[0]))).build(), " ", t});
                }
                cc.add(t);
            }
            Util.getPaginationBuilder(context.getCommandSourceUnchecked()).title(context.getMessage("command.kit.command.commands.title", kit.getName())).contents((Iterable)cc).sendTo((MessageReceiver)context.getCommandSource());
        }
        return context.successResult();
    }
}

