/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"jails"})
@Command(aliases={"jails"}, basePermission={"nucleus.jail.list.base"}, commandDescriptionKey="jails", async=true)
public class JailsCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        JailHandler handler = context.getServiceCollection().getServiceUnchecked(JailHandler.class);
        Map<String, NamedLocation> mjs = handler.getJails();
        if (mjs.isEmpty()) {
            return context.errorResult("command.jails.nojails", new Object[0]);
        }
        List lt = mjs.entrySet().stream().map(x -> this.createJail(context, (NamedLocation)x.getValue(), (String)x.getKey())).collect(Collectors.toList());
        CommandSource src = context.getCommandSource();
        Util.getPaginationBuilder(src).title(context.getMessage("command.jails.list.header", new Object[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)src);
        return context.successResult();
    }

    private Text createJail(ICommandContext<? extends CommandSource> context, @Nullable NamedLocation data, String name) {
        if (data == null || !data.getLocation().isPresent()) {
            return Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.jails.unavailable", new Object[0]))).build();
        }
        Location<World> world = data.getLocation().get();
        LiteralText.Builder inner = Text.builder((String)name).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.runCommand((String)("/jails tp " + name))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.jails.warpprompt", name)));
        return Text.builder().append(new Text[]{inner.build()}).append(new Text[]{context.getMessage("command.warps.warploc", ((World)world.getExtent()).getName(), world.getBlockPosition().toString())}).build();
    }
}

