/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.datatypes.LocationData;
import io.github.nucleuspowered.nucleus.modules.jail.JailParameters;
import io.github.nucleuspowered.nucleus.modules.jail.commands.JailsCommand;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"deljail", "remjail", "rmjail"})
@NonnullByDefault
@Command(aliases={"delete", "del", "remove", "#deljail", "#rmjail", "#deletejail"}, basePermission={"nucleus.jail.delete.base"}, async=true, commandDescriptionKey="jails.delete", parentCommand=JailsCommand.class)
public class DeleteJailCommand
implements ICommandExecutor<CommandSource> {
    private final JailHandler handler;

    @Inject
    public DeleteJailCommand(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(JailHandler.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{JailParameters.JAIL.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        LocationData wl = context.requireOne("jail", LocationData.class);
        if (this.handler.removeJail(wl.getName())) {
            context.sendMessage("command.jails.del.success", wl.getName());
            return context.successResult();
        }
        return context.errorResult("command.jails.del.error", wl.getName());
    }
}

