/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfig;
import io.github.nucleuspowered.nucleus.modules.item.config.RepairConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"repair", "fix"})
@Command(aliases={"repair", "mend", "fix"}, basePermission={"nucleus.repair.base"}, commandDescriptionKey="repair", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.repair.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.repair.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.repair.exempt.cost")}, associatedPermissions={"nucleus.repair.others"})
public class RepairCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean whitelist = false;
    private List<ItemType> restrictions = new ArrayList<ItemType>();

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        RepairConfig config = serviceCollection.moduleDataProvider().getModuleConfig(ItemConfig.class).getRepairConfig();
        this.whitelist = config.isWhitelist();
        this.restrictions = config.getRestrictions();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"m", "-mainhand"}).permissionFlag("nucleus.repair.flag.all", new String[]{"a", "-all"}).permissionFlag("nucleus.repair.flag.hotbar", new String[]{"h", "-hotbar"}).permissionFlag("nucleus.repair.flag.equip", new String[]{"e", "-equip"}).permissionFlag("nucleus.repair.flag.offhand", new String[]{"o", "-offhand"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        EnumMap<ResultType, Integer> resultCount = new EnumMap<ResultType, Integer>(ResultType.class){
            {
                this.put(ResultType.SUCCESS, 0);
                this.put(ResultType.ERROR, 0);
                this.put(ResultType.NEGATIVE_DURABILITY, 0);
                this.put(ResultType.NO_DURABILITY, 0);
                this.put(ResultType.RESTRICTED, 0);
            }
        };
        EnumMap<ResultType, ItemStackSnapshot> lastItem = new EnumMap<ResultType, ItemStackSnapshot>(ResultType.class);
        boolean checkRestrictions = !context.testPermission("nucleus.repair.exempt.restriction");
        Player pl = context.getIfPlayer();
        String location = "inventory";
        if (context.hasAny("a")) {
            this.repairInventory((Inventory)pl.getInventory(), checkRestrictions, resultCount, lastItem);
        } else {
            RepairResult result;
            ItemStack stack;
            boolean repairMainhand;
            boolean repairHotbar = context.hasAny("h");
            boolean repairEquip = context.hasAny("e");
            boolean repairOffhand = context.hasAny("o");
            boolean bl = repairMainhand = context.hasAny("m") || !repairHotbar && !repairEquip && !repairOffhand;
            if (repairHotbar && !repairEquip && !repairOffhand && !repairMainhand) {
                location = "hotbar";
            } else if (repairEquip && !repairHotbar && !repairOffhand && !repairMainhand) {
                location = "equipment";
            } else if (repairOffhand && !repairHotbar && !repairEquip && !repairMainhand) {
                location = "offhand";
            } else if (repairMainhand && !repairHotbar && !repairEquip && !repairOffhand) {
                location = "mainhand";
            }
            if (repairMainhand && pl.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
                stack = (ItemStack)pl.getItemInHand(HandTypes.MAIN_HAND).get();
                result = this.repairStack(stack, checkRestrictions);
                resultCount.compute(result.type, (t, i) -> {
                    i = i + 1;
                    return i;
                });
                lastItem.put(result.type, result.stack.createSnapshot());
                if (result.isSuccessful()) {
                    pl.setItemInHand(HandTypes.MAIN_HAND, result.stack);
                }
            }
            if (repairOffhand && pl.getItemInHand(HandTypes.OFF_HAND).isPresent()) {
                stack = (ItemStack)pl.getItemInHand(HandTypes.OFF_HAND).get();
                result = this.repairStack(stack, checkRestrictions);
                resultCount.compute(result.type, (t, i) -> {
                    i = i + 1;
                    return i;
                });
                lastItem.put(result.type, result.stack.createSnapshot());
                if (result.isSuccessful()) {
                    pl.setItemInHand(HandTypes.OFF_HAND, result.stack);
                }
            }
            if (repairEquip) {
                this.repairInventory(pl.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(EquipmentInventory.class)}), checkRestrictions, resultCount, lastItem);
            }
            if (repairHotbar) {
                this.repairInventory(pl.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)}), checkRestrictions, resultCount, lastItem);
            }
        }
        String key = "command.repair.location." + location;
        IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
        location = messageProviderService.hasKey(key) ? messageProviderService.getMessageString((CommandSource)pl, key, new String[0]) : "inventory";
        if ((Integer)resultCount.get((Object)ResultType.SUCCESS) == 0 && (Integer)resultCount.get((Object)ResultType.ERROR) == 0 && (Integer)resultCount.get((Object)ResultType.NO_DURABILITY) == 0 && (Integer)resultCount.get((Object)ResultType.RESTRICTED) == 0) {
            return context.errorResult("command.repair.empty", pl.getName(), location);
        }
        int durabilityCount = (Integer)resultCount.get((Object)ResultType.NO_DURABILITY) + (Integer)resultCount.get((Object)ResultType.NEGATIVE_DURABILITY);
        if (durabilityCount > 0 && (Integer)resultCount.get((Object)ResultType.SUCCESS) == 0 && (Integer)resultCount.get((Object)ResultType.ERROR) == 0 && (Integer)resultCount.get((Object)ResultType.RESTRICTED) == 0) {
            if (durabilityCount == 1) {
                ItemStackSnapshot item = lastItem.get((Object)ResultType.NO_DURABILITY);
                if (item == null) {
                    item = lastItem.get((Object)ResultType.NEGATIVE_DURABILITY);
                }
                context.sendMessage("command.repair.nodurability.single", ((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), Text.of((String)pl.getName()), Text.of((String)location));
            } else {
                context.sendMessage("command.repair.nodurability.multiple", ((Integer)resultCount.get((Object)ResultType.NO_DURABILITY)).toString(), pl.getName(), location);
            }
        }
        if ((Integer)resultCount.get((Object)ResultType.SUCCESS) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.SUCCESS);
            context.sendMessage("command.repair.success.single", ((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), context.getDisplayName(), location);
        } else if ((Integer)resultCount.get((Object)ResultType.SUCCESS) > 1) {
            context.sendMessage("command.repair.success.multiple", ((Integer)resultCount.get((Object)ResultType.SUCCESS)).toString(), pl.getName(), location);
        }
        if ((Integer)resultCount.get((Object)ResultType.ERROR) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.ERROR);
            context.sendMessage("command.repair.error.single", ((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), context.getDisplayName(), Text.of((String)location));
        } else if ((Integer)resultCount.get((Object)ResultType.ERROR) > 1) {
            context.sendMessage("command.repair.error.multiple", ((Integer)resultCount.get((Object)ResultType.ERROR)).toString(), pl.getName(), location);
        }
        if ((Integer)resultCount.get((Object)ResultType.RESTRICTED) == 1) {
            ItemStackSnapshot item = lastItem.get((Object)ResultType.RESTRICTED);
            context.sendMessage("command.repair.restricted.single", ((Text)item.get(Keys.DISPLAY_NAME).orElse(Text.of((String)item.getTranslation().get()))).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item)).build(), context.getDisplayName(), Text.of((String)location));
        } else if ((Integer)resultCount.get((Object)ResultType.RESTRICTED) > 1) {
            context.sendMessage("command.repair.restricted.multiple", ((Integer)resultCount.get((Object)ResultType.RESTRICTED)).toString(), pl.getName(), location);
        }
        if ((Integer)resultCount.get((Object)ResultType.SUCCESS) > 0) {
            return context.successResult();
        }
        return context.failResult();
    }

    private void repairInventory(Inventory inventory, boolean checkRestrictions, EnumMap<ResultType, Integer> resultCount, EnumMap<ResultType, ItemStackSnapshot> lastItem) {
        for (Inventory slot : inventory.slots()) {
            if (!slot.peek().isPresent() || ((ItemStack)slot.peek().get()).isEmpty()) continue;
            ItemStack stack = (ItemStack)slot.peek().get();
            RepairResult result = this.repairStack(stack, checkRestrictions);
            resultCount.compute(result.type, (t, i) -> {
                i = i + 1;
                return i;
            });
            lastItem.put(result.type, result.stack.createSnapshot());
            if (!result.isSuccessful()) continue;
            slot.set(result.stack);
        }
    }

    private RepairResult repairStack(ItemStack stack, boolean checkRestrictions) {
        if (checkRestrictions && (this.whitelist && !this.restrictions.contains(stack.getType()) || this.restrictions.contains(stack.getType()))) {
            return new RepairResult(stack, ResultType.RESTRICTED);
        }
        try {
            if (stack.get(DurabilityData.class).isPresent()) {
                DurabilityData durabilityData = (DurabilityData)stack.get(DurabilityData.class).get();
                DataTransactionResult transactionResult = stack.offer(Keys.ITEM_DURABILITY, durabilityData.durability().getMaxValue());
                if (transactionResult.isSuccessful()) {
                    return new RepairResult(stack, ResultType.SUCCESS);
                }
                return new RepairResult(stack, ResultType.ERROR);
            }
        }
        catch (IllegalArgumentException e) {
            return new RepairResult(stack, ResultType.NEGATIVE_DURABILITY);
        }
        return new RepairResult(stack, ResultType.NO_DURABILITY);
    }

    private static class RepairResult {
        private final ItemStack stack;
        private final ResultType type;

        RepairResult(ItemStack stack, ResultType type) {
            this.stack = stack;
            this.type = type;
        }

        public boolean isSuccessful() {
            return this.type == ResultType.SUCCESS;
        }
    }

    private static enum ResultType {
        SUCCESS,
        ERROR,
        RESTRICTED,
        NEGATIVE_DURABILITY,
        NO_DURABILITY;

    }
}

