/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.registry;

import ic2.core.IC2;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.components.special.ColoredLocalComp;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Ic2Lang {
    Object2IntOpenHashMap<String> duplicationCheck = new Object2IntOpenHashMap();
    List<LocaleComp> langComponents = new LinkedList<LocaleComp>();
    static Ic2Lang instance = new Ic2Lang();
    public static LocaleComp nullKey = new DisplayLocaleComp("");
    public static LocaleComp northFacing = new LangComponentHolder.TranslationComp("miscInfo.northFacing.name");
    public static LocaleComp southFacing = new LangComponentHolder.TranslationComp("miscInfo.southFacing.name");
    public static LocaleComp eastFacing = new LangComponentHolder.TranslationComp("miscInfo.eastFacing.name");
    public static LocaleComp westFacing = new LangComponentHolder.TranslationComp("miscInfo.westFacing.name");
    public static LocaleComp upFacing = new LangComponentHolder.TranslationComp("miscInfo.upFacing.name");
    public static LocaleComp downFacing = new LangComponentHolder.TranslationComp("miscInfo.downFacing.name");
    public static LocaleComp nullFacing = new LangComponentHolder.TranslationComp("miscInfo.nullFacing.name");
    public static LocaleComp nothingComp = new LangComponentHolder.TranslationComp("miscInfo.null.name");
    public static LocaleComp nothingHappend = new LangComponentHolder.TranslationComp("miscInfo.nothingHappend.name");
    public static LocaleComp supportedUpgrades = new LangComponentHolder.TranslationComp("miscInfo.supportedUpgrades.name");
    public static LocaleComp yes = new LangComponentHolder.TranslationComp("miscInfo.yes.name");
    public static LocaleComp no = new LangComponentHolder.TranslationComp("miscInfo.no.name");
    public static LocaleComp accessNothing = new LangComponentHolder.TranslationComp("miscInfo.accessNothing.name");
    public static LocaleComp accessImport = new LangComponentHolder.TranslationComp("miscInfo.accessImport.name");
    public static LocaleComp accessExport = new LangComponentHolder.TranslationComp("miscInfo.accessExport.name");
    public static LocaleComp accessBoth = new LangComponentHolder.TranslationComp("miscInfo.accessBoth.name");
    public static LocaleComp pressCtrl = new ColoredLocalComp("miscInfo.pressCtrl.name", TextFormatting.GOLD);
    public static LocaleComp pressShift = new ColoredLocalComp("miscInfo.pressShift.name", TextFormatting.AQUA);
    public static LocaleComp pressAlt = new ColoredLocalComp("miscInfo.pressAlt.name", TextFormatting.GOLD);
    public static LocaleComp pressTo = new LangComponentHolder.TranslationComp("miscInfo.pressTo.name");
    public static LocaleComp pathLoss = new LangComponentHolder.TranslationComp("miscInfo.pathLoss.name");
    public static LocaleComp upgradeEU = new LangComponentHolder.TranslationComp("miscInfo.euUpgrade.name");
    public static LocaleComp upgradeCrop = new LangComponentHolder.TranslationComp("miscInfo.cropUpgrade.name");
    public static LocaleComp upgradeThermo = new LangComponentHolder.TranslationComp("miscInfo.thermoUpgrade.name");
    public static LocaleComp configUpdated = new LangComponentHolder.TranslationComp("configInfo.configUpdated.name");
    public static LocaleComp configUpdatedWorld = new LangComponentHolder.TranslationComp("configInfo.configUpdatedWorld.name");
    public static LocaleComp configUpdatedGame = new LangComponentHolder.TranslationComp("configInfo.configUpdatedGame.name");
    public static LocaleComp onItemRightClick = new LangComponentHolder.TranslationComp("miscInfo.onItemRightClick.name");
    public static LocaleComp onBlockClick = new LangComponentHolder.TranslationComp("miscInfo.onBlockClick.name");
    public static LocaleComp openTheItemInventory = new LangComponentHolder.TranslationComp("miscInfo.openTheItemInventory.name");
    public static LocaleComp savedAchievement = new LangComponentHolder.TranslationComp("miscInfo.achievementSaved.name");
    public static LocaleComp cantPlantHere = new LangComponentHolder.TranslationComp("miscInfo.cantPlantHere.name");
    public static LocaleComp toLittleItems = new LangComponentHolder.TranslationComp("miscInfo.notEnoughSeeds.name");
    public static LocaleComp soilData = new LangComponentHolder.TranslationComp("miscInfo.cropSoil.name");
    public static LocaleComp soilInfo = new LangComponentHolder.TranslationComp("miscInfo.cropSoilInfo.name");
    public static LocaleComp farmlandData = new LangComponentHolder.TranslationComp("miscInfo.farmland.name");
    public static LocaleComp farmlandInfo = new LangComponentHolder.TranslationComp("miscInfo.farmlandInfo.name");

    public static Ic2Lang getInstance() {
        return instance;
    }

    public void init() {
        LocaleComp lang = Ic2BlockLang.advMachine;
        lang = Ic2ItemLang.quantumJetplate;
        lang = Ic2GuiLang.mcInv;
        lang = Ic2InfoLang.ampliefier;
        this.reload();
    }

    public void addLocaleComponent(LocaleComp comp) {
        this.langComponents.add(comp);
    }

    public void doDuplicationCheck(LocaleComp comp) {
        if (this.duplicationCheck.addTo((Object)comp.getUnlocalizedFully(), 1) >= 10) {
            Thread.dumpStack();
            IC2.platform.displayError("[" + comp.getUnlocalizedFully() + "] got a Duplicated Entry that would cause a memory leak. Please Contact the dev to fix this");
        }
    }

    public void reload() {
        this.duplicationCheck.clear();
        for (LocaleComp entry : this.langComponents) {
            entry.reload();
        }
    }

    public static String translateToLocal(String key) {
        return I18n.func_74838_a((String)key);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftDown(List<String> tooltip) {
        if (GuiScreen.func_146272_n()) {
            return true;
        }
        tooltip.add(pressShift.getLocalized());
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCtrlDown(List<String> tooltip) {
        if (GuiScreen.func_146271_m()) {
            return true;
        }
        tooltip.add(pressCtrl.getLocalized());
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isAltDown(List<String> tooltip) {
        if (GuiScreen.func_175283_s()) {
            return true;
        }
        tooltip.add(pressAlt.getLocalized());
        return false;
    }

    public static LocaleComp getFacingComp(EnumFacing side) {
        if (side == null) {
            return nullFacing;
        }
        switch (side) {
            case DOWN: {
                return downFacing;
            }
            case EAST: {
                return eastFacing;
            }
            case NORTH: {
                return northFacing;
            }
            case SOUTH: {
                return southFacing;
            }
            case UP: {
                return upFacing;
            }
            case WEST: {
                return westFacing;
            }
        }
        return nullFacing;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LangReloader
    implements IResourceManagerReloadListener {
        public void func_110549_a(IResourceManager resourceManager) {
            Ic2Lang.getInstance().reload();
        }
    }
}

