/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.capabilities.energy;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.core.IC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SinkLimiterHandler {
    IMachine machine;
    ItemStack upgrade;
    int tier = 1;

    public SinkLimiterHandler() {
        this.init();
    }

    public void readFromNBT(NBTTagCompound data) {
        this.upgrade = data.func_74764_b("Upgrade") ? new ItemStack(data.func_74775_l("Upgrade")) : ItemStack.field_190927_a;
        this.recalculate();
    }

    public void writeToNBT(NBTTagCompound data) {
        if (this.upgrade != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.upgrade.func_77955_b(item);
            data.func_74782_a("Upgrade", (NBTBase)item);
        }
    }

    public int getTier() {
        return this.tier;
    }

    public ItemStack removeOne() {
        if (this.upgrade == null) {
            return null;
        }
        ItemStack split = this.upgrade.func_77979_a(1);
        this.recalculate();
        return split;
    }

    public boolean addUpgrade(ItemStack stack, EntityPlayer player) {
        if (!(stack.func_77973_b() instanceof IMachineUpgradeItem)) {
            return false;
        }
        IMachineUpgradeItem item = (IMachineUpgradeItem)stack.func_77973_b();
        if (item.getType(stack) != IMachineUpgradeItem.UpgradeType.MachineModifierB) {
            return false;
        }
        if (this.upgrade.func_190926_b()) {
            this.upgrade = stack.func_77979_a(1);
            this.recalculate();
            return true;
        }
        if (this.tier == 13 || this.upgrade.func_190916_E() >= this.upgrade.func_77976_d()) {
            IC2.platform.messagePlayer(player, Ic2InfoLang.upgradeReachedMax);
            return false;
        }
        if (StackUtil.isStackEqual(this.upgrade, stack, false, false)) {
            stack.func_77979_a(1);
            this.upgrade.func_190917_f(1);
            this.recalculate();
            return true;
        }
        return false;
    }

    void recalculate() {
        this.tier = !this.upgrade.func_190926_b() ? Math.min(13, 1 + ((IMachineUpgradeItem)this.upgrade.func_77973_b()).getExtraTier(this.upgrade, this.machine) * this.upgrade.func_190916_E()) : 1;
    }

    void init() {
        this.machine = new IMachine(){
            Set<IMachineUpgradeItem.UpgradeType> types = new HashSet<IMachineUpgradeItem.UpgradeType>(Arrays.asList(IMachineUpgradeItem.UpgradeType.MachineModifierB));

            @Override
            public double getEnergy() {
                return 0.0;
            }

            @Override
            public boolean useEnergy(double amount, boolean simulate) {
                return false;
            }

            @Override
            public void setRedstoneSensitive(boolean active) {
            }

            @Override
            public boolean isRedstoneSensitive() {
                return false;
            }

            @Override
            public boolean isProcessing() {
                return false;
            }

            @Override
            public boolean isValidInput(ItemStack par1) {
                return false;
            }

            @Override
            public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
                return this.types;
            }

            @Override
            public World getMachineWorld() {
                return null;
            }

            @Override
            public BlockPos getMachinePos() {
                return null;
            }
        };
    }
}

