/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.fieldEvents.item;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.inventory.management.AccessRule;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class SlotTypeModifierFieldData
implements INetworkFieldData {
    boolean offHand;
    Map<Integer, Map<EnumFacing, AccessRule>> rules = new LinkedHashMap<Integer, Map<EnumFacing, AccessRule>>();
    Map<Integer, AccessRule> masters = new LinkedHashMap<Integer, AccessRule>();

    public void putData(Map<Integer, Map<EnumFacing, AccessRule>> data) {
        this.rules.putAll(data);
    }

    public void putMasters(Map<Integer, AccessRule> master) {
        this.masters.putAll(master);
    }

    public void sendOff(boolean hand) {
        this.offHand = hand;
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.offHand = buffer.readBoolean();
        AccessRule[] array = AccessRule.values();
        int expectedSlots = buffer.readByte();
        for (int x = 0; x < expectedSlots; ++x) {
            byte slot = buffer.readByte();
            this.masters.put(Integer.valueOf(slot), array[buffer.readByte()]);
            EnumMap<EnumFacing, AccessRule> map = new EnumMap<EnumFacing, AccessRule>(EnumFacing.class);
            int expectedSides = buffer.readByte();
            for (int i = 0; i < expectedSides; ++i) {
                EnumFacing side = EnumFacing.field_82609_l[buffer.readByte()];
                AccessRule rule = array[buffer.readByte()];
                map.put(side, rule);
            }
            this.rules.put(Integer.valueOf(slot), map);
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeBoolean(this.offHand);
        buffer.writeByte((byte)this.rules.size());
        for (Map.Entry<Integer, Map<EnumFacing, AccessRule>> entry : this.rules.entrySet()) {
            buffer.writeByte(entry.getKey().byteValue());
            buffer.writeByte((byte)this.masters.get(entry.getKey()).ordinal());
            Map<EnumFacing, AccessRule> rule = entry.getValue();
            buffer.writeByte((byte)rule.size());
            for (Map.Entry<EnumFacing, AccessRule> map : rule.entrySet()) {
                buffer.writeByte((byte)map.getKey().ordinal());
                buffer.writeByte((byte)map.getValue().ordinal());
            }
        }
    }

    public Map<Integer, Map<EnumFacing, AccessRule>> getData() {
        return this.rules;
    }

    public Map<Integer, AccessRule> getMasterRules() {
        return this.masters;
    }

    public boolean isOffHand() {
        return this.offHand;
    }
}

