/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.item.ElectricItem;
import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorQuantumJetplate
extends ItemArmorQuantumSuit
implements ItemArmorJetpackBase.IIndirectJetpack {
    public QuantumJetpack jetpack = new QuantumJetpack((Item)this);

    public ItemArmorQuantumJetplate() {
        super(44, EntityEquipmentSlot.CHEST);
        this.setUnlocalizedName(Ic2ItemLang.quantumJetplate);
        this.maxCharge = 2500000;
        this.transferLimit = 2500;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/quantumjetpack";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        this.jetpack.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        this.jetpack.onArmorTick(world, player, stack);
    }

    @Override
    public ItemArmorJetpackBase getJetpack() {
        return this.jetpack;
    }

    public static class QuantumJetpack
    extends ItemArmorElectricJetpackBase {
        Item item;

        public QuantumJetpack(Item owner) {
            super(-1, EntityEquipmentSlot.CHEST);
            this.item = owner;
        }

        @Override
        public boolean canDisable(ItemStack stack) {
            return true;
        }

        @Override
        public boolean canProvideEnergy(ItemStack stack) {
            return false;
        }

        @Override
        public double getMaxCharge(ItemStack stack) {
            return ElectricItem.manager.getMaxCharge(stack);
        }

        @Override
        public int getTier(ItemStack stack) {
            return ElectricItem.manager.getTier(stack);
        }

        @Override
        public double getTransferLimit(ItemStack stack) {
            return 0.0;
        }

        @Override
        public boolean canDoRocketMode(ItemStack stack) {
            return true;
        }

        @Override
        public boolean canDoAdvHoverMode(ItemStack stack) {
            return true;
        }

        @Override
        public boolean isElectricJetpack(ItemStack stack) {
            return true;
        }

        @Override
        public float getPower(ItemStack stack) {
            return 2.5f;
        }

        @Override
        public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
            switch (mode) {
                case Adv: {
                    return 3.5f;
                }
                case Basic: {
                    return 2.5f;
                }
                case None: {
                    return 1.5f;
                }
            }
            return 2.5f;
        }

        @Override
        public float getDropPercentage(ItemStack stack) {
            return 0.05f;
        }

        @Override
        public int getMaxHeight(ItemStack stack, int worldHeight) {
            return worldHeight;
        }

        @Override
        public int getMaxRocketCharge(ItemStack stack) {
            return 30000;
        }

        @Override
        public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
            switch (mode) {
                case None: {
                    return 30;
                }
                case Basic: {
                    return 27;
                }
                case Adv: {
                    return 30;
                }
            }
            return 27;
        }

        @Override
        public String getTexture() {
            return "";
        }

        @Override
        public void useEnergy(EntityPlayer player, ItemStack stack, int amount) {
            ElectricItem.manager.use(stack, amount, (EntityLivingBase)player);
        }
    }
}

