/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.filters;

import ic2.core.inventory.filters.IFilter;
import ic2.core.util.misc.FluidHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidContainerFilter
implements IFilter {
    IFluidHandler tank;
    boolean fill;
    boolean basic;

    public FluidContainerFilter(IFluidHandler prov) {
        this.fill = true;
        this.tank = prov;
        this.basic = false;
    }

    public FluidContainerFilter(boolean doFill) {
        this.fill = doFill;
        this.basic = true;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.fill) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
            if (handler != null) {
                if (this.basic) {
                    return handler.getTankProperties()[0].canFill();
                }
                return FluidHelper.canFillFluidToHandler((IFluidHandler)handler, FluidHelper.copyFluid(this.tank.getTankProperties()[0].getContents()));
            }
            return false;
        }
        return FluidUtil.getFluidContained((ItemStack)stack) != null;
    }
}

