/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.explosion;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import ic2.api.tile.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.block.machine.med.TileEntityTeslaCoil;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.IC2Potion;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionIC2 {
    private Random rand;
    private World world;
    private int worldHeight;
    public double xStart;
    public double yStart;
    public double zStart;
    public Entity exploder;
    public float power;
    public float dropRate;
    public float damage;
    public DamageSource source;
    public GameProfile igniter;
    public List<EntityLivingBase> entitiesInRange = new ArrayList<EntityLivingBase>();
    public Map<BlockPos, Tuple<IBlockState, Boolean>> destroyedBlocks = new LinkedHashMap<BlockPos, Tuple<IBlockState, Boolean>>();
    public AxisAlignedBB box;
    private Explosion fakeExplosion;
    public boolean isBeacon;

    public ExplosionIC2(World world, Entity entity, Vec3d pos, float pow, float drop, float entityDamage, DamageSource damageSource) {
        this.world = world;
        this.worldHeight = world.func_72940_L();
        this.rand = world.field_73012_v;
        this.exploder = entity;
        this.xStart = pos.field_72450_a;
        this.yStart = pos.field_72448_b;
        this.zStart = pos.field_72449_c;
        this.power = pow;
        this.dropRate = drop;
        this.damage = entityDamage;
        this.source = damageSource;
        this.fakeExplosion = new Explosion(world, entity, this.xStart, this.yStart, this.zStart, (float)((double)this.power / 0.4), false, false);
        if (this.source == null) {
            this.source = DamageSource.func_94539_a((Explosion)this.fakeExplosion);
        }
    }

    public ExplosionIC2 setIgniter(EntityPlayer player) {
        return player == null ? this : this.setIgniter(player.func_146103_bH());
    }

    public ExplosionIC2 setIgniter(GameProfile profile) {
        this.igniter = profile;
        return this;
    }

    public void doExplosion() {
        if (this.power <= 0.0f) {
            return;
        }
        if (ForgeEventFactory.onExplosionStart((World)this.world, (Explosion)this.fakeExplosion)) {
            return;
        }
        double max = (double)this.power / 0.4;
        BlockPos axis = new BlockPos(this.xStart, this.yStart, this.zStart);
        this.box = new AxisAlignedBB(axis.func_177963_a(-max, -max, -max), axis.func_177963_a(max, max, max));
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / max));
        this.entitiesInRange.addAll(this.world.func_175647_a(EntityLivingBase.class, this.box, NukeTargets.nuke));
        for (int x = 0; x < steps * 2; ++x) {
            double phi = Math.PI * 2 / (double)steps * (double)x;
            for (int y = 0; y < steps; ++y) {
                double theta = Math.PI / (double)steps * (double)y;
                this.shootRay(this.xStart, this.yStart, this.zStart, phi, theta, this.power, x % 8 == 0 && y % 8 == 0);
            }
        }
        if (this.source == IC2DamageSource.nuke) {
            for (EntityLivingBase entity : this.world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.xStart - 100.0, this.yStart - 100.0, this.zStart - 100.0, this.xStart + 100.0, this.yStart + 100.0, this.zStart + 100.0), TileEntityTeslaCoil.shockPrediction)) {
                if (entity instanceof EntityPlayer && this.isBeacon) {
                    entity.func_70097_a((DamageSource)IC2DamageSource.nuke, 1000.0f);
                }
                double d = entity.func_70011_f(this.xStart, this.yStart, this.zStart);
                int hungerLength = (int)(120.0 * (100.0 - d));
                int poisonLength = (int)(80.0 * (30.0 - d));
                if (hungerLength >= 0) {
                    entity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)17), hungerLength, 0));
                }
                if (poisonLength < 0) continue;
                entity.func_70690_d(new PotionEffect((Potion)IC2Potion.radiation, poisonLength, 0));
            }
            for (EntityLivingBase entry : this.entitiesInRange) {
                if (!(entry instanceof EntityPlayer)) continue;
                EntityPlayer entityPlayer = (EntityPlayer)entry;
                IC2.achievements.issueStat(entityPlayer, "nukesSurvived");
            }
        }
        IC2.network.get().initiateExplosionEffect(this.world, this.xStart, this.yStart, this.zStart, this.source == IC2DamageSource.nuke);
        LinkedHashMap<BlockPos, List> drops = new LinkedHashMap<BlockPos, List>();
        for (Map.Entry<BlockPos, Tuple<IBlockState, Boolean>> entry : this.destroyedBlocks.entrySet()) {
            BlockPos pos = entry.getKey();
            Tuple<IBlockState, Boolean> value = entry.getValue();
            IBlockState state = (IBlockState)value.func_76341_a();
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            if (((Boolean)value.func_76340_b()).booleanValue() && state.func_177230_c().func_149659_a(this.fakeExplosion)) {
                List list;
                double effectX = (float)pos.func_177958_n() + this.world.field_73012_v.nextFloat();
                double effectY = (float)pos.func_177956_o() + this.world.field_73012_v.nextFloat();
                double effectZ = (float)pos.func_177952_p() + this.world.field_73012_v.nextFloat();
                double d3 = effectX - this.xStart;
                double d2 = effectY - this.yStart;
                d3 = effectZ - this.zStart;
                double effectDistance = MathHelper.func_76133_a((double)(d3 * d3 + d2 * d2 + d3 * d3));
                d3 /= effectDistance;
                d2 /= effectDistance;
                d3 /= effectDistance;
                double d4 = 0.5 / (effectDistance / (double)this.power + 0.1);
                d3 *= (d4 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f));
                this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (effectX + this.xStart) / 2.0, (effectY + this.yStart) / 2.0, (effectZ + this.zStart) / 2.0, d3 *= d4, d2 *= d4, d3, new int[0]);
                this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, effectX, effectY, effectZ, d3, d2, d3, new int[0]);
                if (this.rand.nextFloat() <= this.dropRate && (list = state.func_177230_c().getDrops((IBlockAccess)this.world, pos, state, 0)) != null && list.size() > 0) {
                    drops.put(pos, list);
                }
            }
            state.func_177230_c().onBlockExploded(this.world, pos, this.fakeExplosion);
        }
        for (Map.Entry<Object, Object> entry : drops.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            for (ItemStack item : (List)entry.getValue()) {
                EntityItem entity = new EntityItem(this.world, (double)((float)pos.func_177958_n() + this.rand.nextFloat()), (double)pos.func_177956_o() + 0.5, (double)((float)pos.func_177952_p() + this.rand.nextFloat()), item);
                entity.func_174867_a(10);
                this.world.func_72838_d((Entity)entity);
            }
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power, boolean killEntities) {
        Vec3d vec;
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        int step = 0;
        while (this.box.func_72318_a(vec = new Vec3d(x, y, z))) {
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = this.world.func_180495_p(pos);
            boolean isAir = state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos);
            double absorption = 0.5;
            if (!isAir) {
                double resistance = state.func_177230_c().getExplosionResistance(this.world, pos, this.exploder, this.fakeExplosion);
                if (resistance < 0.0) break;
                absorption = (resistance + 4.0) * 0.3;
            }
            if (absorption > 1000.0 && !ExplosionWhitelist.isBlockWhitelisted(state.func_177230_c())) {
                absorption = 0.5;
            } else {
                BlockPos imute;
                Tuple<IBlockState, Boolean> entry;
                if (absorption > power) break;
                if (!isAir && ((entry = this.destroyedBlocks.get(imute = pos.func_185334_h())) == null || power > 8.0 && ((Boolean)entry.func_76340_b()).booleanValue())) {
                    this.destroyedBlocks.put(imute, (Tuple<IBlockState, Boolean>)new Tuple((Object)state, (Object)(power <= 8.0 ? 1 : 0)));
                }
            }
            if (killEntities && step % 8 == 0 && this.entitiesInRange.size() > 0 && power >= 0.25) {
                ArrayList<EntityLivingBase> alive = new ArrayList<EntityLivingBase>(this.entitiesInRange.size());
                boolean nuke = this.source == IC2DamageSource.nuke;
                for (EntityLivingBase entity : this.entitiesInRange) {
                    if (!entity.func_180427_aV() && entity.func_174791_d().func_72438_d(vec) <= power / 1.5) {
                        double xDistance = entity.field_70165_t - this.xStart;
                        double yDistance = entity.field_70163_u - this.yStart;
                        double zDistance = entity.field_70161_v - this.zStart;
                        double distance = Math.sqrt(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance);
                        double distanceFactor = power / 2.0 / (Math.pow(distance, 0.8) + 1.0);
                        entity.func_70097_a(this.source, (float)Math.pow(distanceFactor * 3.0, 2.0));
                        if (!entity.func_70089_S()) {
                            if (this.igniter != null) {
                                EntityPlayer player;
                                if (nuke && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_146103_bH().equals((Object)this.igniter)) {
                                    IC2.achievements.issueStat((EntityPlayer)entity, "diedFromNuke");
                                }
                                if (entity instanceof EntityWither && (player = this.world.func_152378_a(this.igniter.getId())) != null) {
                                    IC2.achievements.issueStat(player, "nukedWither");
                                }
                            }
                        } else {
                            alive.add(entity);
                        }
                        entity.field_70159_w += (xDistance /= distance) * distanceFactor;
                        entity.field_70181_x += (yDistance /= distance) * distanceFactor;
                        entity.field_70179_y += (zDistance /= distance) * distanceFactor;
                        continue;
                    }
                    alive.add(entity);
                }
                this.entitiesInRange = alive;
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.rand.nextDouble() * 2.0 * Math.PI, this.rand.nextDouble() * Math.PI, power - absorption, false);
                }
            }
            power -= absorption;
            x += deltaX;
            z += deltaZ;
            ++step;
            if ((y += deltaY) < (double)this.worldHeight) continue;
        }
    }

    public static class NukeTargets
    implements Predicate<EntityLivingBase> {
        public static Predicate<EntityLivingBase> nuke = new NukeTargets();

        public boolean apply(@Nullable EntityLivingBase input) {
            if (input instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)input;
                if (player.func_175149_v()) {
                    return false;
                }
                if (player.field_71075_bZ.field_75102_a) {
                    return false;
                }
            }
            return input.func_70089_S();
        }
    }
}

