/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ILeverModule;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleBrake
extends ModuleAddon
implements ILeverModule {
    private int[] startstopRect = new int[]{15, 20, 24, 12};
    private int[] turnbackRect = new int[]{this.startstopRect[0] + this.startstopRect[2] + 5, this.startstopRect[1], this.startstopRect[2], this.startstopRect[3]};
    private DataParameter<Boolean> FORGE_STOPPING;

    public ModuleBrake(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ADDONS.CONTROL_LEVER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/lever.png");
        this.drawButton(gui, x, y, this.startstopRect, this.isForceStopping() ? 2 : 1);
        this.drawButton(gui, x, y, this.turnbackRect, 0);
    }

    private void drawButton(GuiMinecart gui, int x, int y, int[] coords, int imageID) {
        if (this.inRect(x, y, coords)) {
            this.drawImage(gui, coords, 0, coords[3]);
        } else {
            this.drawImage(gui, coords, 0, 0);
        }
        int srcY = coords[3] * 2 + imageID * (coords[3] - 2);
        this.drawImage(gui, coords[0] + 1, coords[1] + 1, 0, srcY, coords[2] - 2, coords[3] - 2);
    }

    @Override
    public boolean stopEngines() {
        return this.isForceStopping();
    }

    private boolean isForceStopping() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getBrakeActive();
        }
        return this.getDw(this.FORGE_STOPPING);
    }

    private void setForceStopping(boolean val) {
        this.updateDw(this.FORGE_STOPPING, val);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, this.isForceStopping() ? Localization.MODULES.ADDONS.LEVER_START.translate(new String[0]) : Localization.MODULES.ADDONS.LEVER_STOP.translate(new String[0]), x, y, this.startstopRect);
        this.drawStringOnMouseOver(gui, Localization.MODULES.ADDONS.LEVER_TURN.translate(new String[0]), x, y, this.turnbackRect);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            if (this.inRect(x, y, this.startstopRect)) {
                this.sendPacket(0);
            } else if (this.inRect(x, y, this.turnbackRect)) {
                this.sendPacket(1);
            }
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.setForceStopping(!this.isForceStopping());
        } else if (id == 1) {
            this.turnback();
        }
    }

    @Override
    public int numberOfPackets() {
        return 2;
    }

    @Override
    public float getLeverState() {
        if (this.isForceStopping()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.FORGE_STOPPING = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.FORGE_STOPPING, false);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74757_a(this.generateNBTName("ForceStop", id), this.isForceStopping());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setForceStopping(tagCompound.func_74767_n(this.generateNBTName("ForceStop", id)));
    }
}

