/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.type.PlantTypes;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.EmptyObject;
import org.spongepowered.api.util.weighted.SeededVariableAmount;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.populator.BigMushroom;
import org.spongepowered.api.world.gen.populator.Cactus;
import org.spongepowered.api.world.gen.populator.DeadBush;
import org.spongepowered.api.world.gen.populator.Flower;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Fossil;
import org.spongepowered.api.world.gen.populator.Glowstone;
import org.spongepowered.api.world.gen.populator.Melon;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.populator.NetherFire;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.gen.populator.Pumpkin;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.api.world.gen.populator.Reed;
import org.spongepowered.api.world.gen.populator.SeaFloor;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.api.world.gen.populator.Vine;
import org.spongepowered.api.world.gen.populator.WaterLily;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.common.mixin.core.world.biome.BiomeDecoratorAccessor;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.SandstoneGroundCoverLayer;
import org.spongepowered.common.world.gen.populators.FlowerForestSupplier;
import org.spongepowered.common.world.gen.populators.HellMushroomPopulator;
import org.spongepowered.common.world.gen.populators.RoofedForestPopulator;

public final class WorldGenConstants {
    public static final String VILLAGE_FLAG = "VILLAGE";
    private static final Class<?>[] MIXINED_CHUNK_PROVIDERS = new Class[]{ChunkGeneratorOverworld.class, ChunkGeneratorFlat.class, ChunkGeneratorHell.class, ChunkGeneratorEnd.class};
    public static final SeededVariableAmount<Double> GROUND_COVER_DEPTH = new SeededVariableAmount<Double>(){

        @Override
        public double getAmount(Random rand, Double seed) {
            return (int)(seed / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        }
    };
    public static final Predicate<BlockState> DIRT_OR_GRASS = input -> input.getType().equals(BlockTypes.DIRT) || input.getType().equals(BlockTypes.GRASS);
    public static final Predicate<BlockState> DIRT = input -> input.getType().equals(BlockTypes.DIRT);
    public static final Predicate<BlockState> STONE = input -> input.getType().equals(BlockTypes.STONE);
    public static final Predicate<Location<World>> STONE_LOCATION = input -> input.getBlock().getType().equals(BlockTypes.STONE);
    public static final Predicate<Location<World>> CAVE_LIQUIDS = input -> {
        if (input.getBlockY() <= 0 || input.getBlockY() >= 255) {
            return false;
        }
        if (input.add(0.0, 1.0, 0.0).getBlock().getType() != BlockTypes.STONE || input.add(0.0, -1.0, 0.0).getBlock().getType() != BlockTypes.STONE || input.getBlock().getType() != BlockTypes.STONE && input.getBlock().getType() != BlockTypes.AIR) {
            return false;
        }
        int air = 0;
        int stone = 0;
        if (input.add(1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(-1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(0.0, 0.0, 1.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(0.0, 0.0, -1.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(-1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(0.0, 0.0, 1.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(0.0, 0.0, -1.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        return air == 1 && stone == 3;
    };
    public static final Predicate<Location<World>> HELL_LAVA = input -> {
        if (input.add(0.0, 1.0, 0.0).getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        if (input.getBlockType() != BlockTypes.AIR && input.getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        int i = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        int j = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        return i == 4 && j == 1;
    };
    public static final Predicate<Location<World>> HELL_LAVA_ENCLOSED = input -> {
        if (input.add(0.0, 1.0, 0.0).getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        if (input.getBlockType() != BlockTypes.AIR && input.getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        int i = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        return i == 5;
    };
    public static boolean lightingEnabled = true;

    public static boolean isValid(IChunkGenerator cp, Class<?> api_type) {
        if (api_type.isInstance(cp)) {
            for (Class<?> mixind : MIXINED_CHUNK_PROVIDERS) {
                if (cp.getClass().equals(mixind)) {
                    return true;
                }
                if (!mixind.isInstance(cp)) continue;
                for (Class<?> anInterface : cp.getClass().getInterfaces()) {
                    if (!api_type.equals(anInterface)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void disableLighting() {
        lightingEnabled = false;
    }

    public static void enableLighting() {
        lightingEnabled = true;
    }

    private WorldGenConstants() {
    }

    public static void buildPopulators(net.minecraft.world.World world, SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator, IBlockState topBlock, IBlockState fillerBlock) {
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)topBlock, SeededVariableAmount.fixed(1.0)));
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)fillerBlock, GROUND_COVER_DEPTH));
        if (fillerBlock.func_177230_c() == Blocks.field_150354_m) {
            BlockType type = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? BlockTypes.RED_SANDSTONE : BlockTypes.SANDSTONE;
            gensettings.getGroundCoverLayers().add(new SandstoneGroundCoverLayer(type.getDefaultState()));
        }
        String s = world.func_72912_H().func_82571_y();
        ChunkGeneratorSettings settings = ChunkGeneratorSettings.Factory.func_177865_a((String)s).func_177864_b();
        Ore dirt = Ore.builder().ore((BlockState)Blocks.field_150346_d.func_176223_P()).size(settings.field_177789_I).perChunk(settings.field_177790_J).height(VariableAmount.baseWithRandomAddition((double)settings.field_177791_K, settings.field_177784_L - settings.field_177791_K)).build();
        gensettings.getPopulators().add(dirt);
        Ore gravel = Ore.builder().ore((BlockState)Blocks.field_150351_n.func_176223_P()).size(settings.field_177785_M).perChunk(settings.field_177786_N).height(VariableAmount.baseWithRandomAddition((double)settings.field_177787_O, settings.field_177797_P - settings.field_177787_O)).build();
        gensettings.getPopulators().add(gravel);
        Ore diorite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE)).size(settings.field_177792_U).perChunk(settings.field_177795_V).height(VariableAmount.baseWithRandomAddition((double)settings.field_177794_W, settings.field_177801_X - settings.field_177794_W)).build();
        gensettings.getPopulators().add(diorite);
        Ore granite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE)).size(settings.field_177796_Q).perChunk(settings.field_177799_R).height(VariableAmount.baseWithRandomAddition((double)settings.field_177798_S, settings.field_177793_T - settings.field_177798_S)).build();
        gensettings.getPopulators().add(granite);
        Ore andesite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE)).size(settings.field_177800_Y).perChunk(settings.field_177802_Z).height(VariableAmount.baseWithRandomAddition((double)settings.field_177846_aa, settings.field_177847_ab - settings.field_177846_aa)).build();
        gensettings.getPopulators().add(andesite);
        Ore coal = Ore.builder().ore((BlockState)Blocks.field_150365_q.func_176223_P()).size(settings.field_177844_ac).perChunk(settings.field_177845_ad).height(VariableAmount.baseWithRandomAddition((double)settings.field_177851_ae, settings.field_177853_af - settings.field_177851_ae)).build();
        gensettings.getPopulators().add(coal);
        Ore iron = Ore.builder().ore((BlockState)Blocks.field_150366_p.func_176223_P()).size(settings.field_177848_ag).perChunk(settings.field_177849_ah).height(VariableAmount.baseWithRandomAddition((double)settings.field_177832_ai, settings.field_177834_aj - settings.field_177832_ai)).build();
        gensettings.getPopulators().add(iron);
        Ore gold = Ore.builder().ore((BlockState)Blocks.field_150352_o.func_176223_P()).size(settings.field_177828_ak).perChunk(settings.field_177830_al).height(VariableAmount.baseWithRandomAddition((double)settings.field_177840_am, settings.field_177842_an - settings.field_177840_am)).build();
        gensettings.getPopulators().add(gold);
        Ore redstone = Ore.builder().ore((BlockState)Blocks.field_150450_ax.func_176223_P()).size(settings.field_177836_ao).perChunk(settings.field_177838_ap).height(VariableAmount.baseWithRandomAddition((double)settings.field_177818_aq, settings.field_177816_ar - settings.field_177818_aq)).build();
        gensettings.getPopulators().add(redstone);
        Ore diamond = Ore.builder().ore((BlockState)Blocks.field_150482_ag.func_176223_P()).size(settings.field_177814_as).perChunk(settings.field_177812_at).height(VariableAmount.baseWithRandomAddition((double)settings.field_177826_au, settings.field_177824_av - settings.field_177826_au)).build();
        gensettings.getPopulators().add(diamond);
        Ore lapis = Ore.builder().ore((BlockState)Blocks.field_150369_x.func_176223_P()).size(settings.field_177822_aw).perChunk(settings.field_177820_ax).height(VariableAmount.baseWithVariance((double)settings.field_177807_ay, settings.field_177805_az)).build();
        gensettings.getPopulators().add(lapis);
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        if (accessor.accessor$getSandPerChunk() > 0) {
            SeaFloor sand = SeaFloor.builder().block((BlockState)Blocks.field_150354_m.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 5.0)).depth(2).perChunk(accessor.accessor$getSandPerChunk()).replace(DIRT_OR_GRASS).build();
            gensettings.getPopulators().add(sand);
        }
        if (accessor.accessor$getClayPerChunk() > 0) {
            SeaFloor clay = SeaFloor.builder().block((BlockState)Blocks.field_150435_aG.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 2.0)).depth(1).perChunk(accessor.accessor$getClayPerChunk()).replace(DIRT).build();
            gensettings.getPopulators().add(clay);
        }
        if (accessor.accessor$getGravelPerChunk() > 0) {
            SeaFloor gravelSeaFloor = SeaFloor.builder().block((BlockState)Blocks.field_150351_n.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 4.0)).depth(2).perChunk(accessor.accessor$getGravelPerChunk()).replace(DIRT_OR_GRASS).build();
            gensettings.getPopulators().add(gravelSeaFloor);
        }
        Forest forest = Forest.builder().type(BiomeTreeTypes.OAK.getPopulatorObject(), 9.0).type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0).perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1)).build();
        gensettings.getPopulators().add(forest);
        if (accessor.accessor$getBigMushroomsPerChunk() > 0) {
            BigMushroom mushroom = BigMushroom.builder().mushroomsPerChunk(accessor.accessor$getBigMushroomsPerChunk()).type(MushroomTypes.BROWN.getPopulatorObject(), 1.0).type(MushroomTypes.RED.getPopulatorObject(), 1.0).build();
            gensettings.getPopulators().add(mushroom);
        }
        if (accessor.accessor$getFlowersPerChunk() > 0) {
            Flower flower = Flower.builder().perChunk(accessor.accessor$getFlowersPerChunk() * 64).type(PlantTypes.DANDELION, 2.0).type(PlantTypes.POPPY, 1.0).build();
            gensettings.getPopulators().add(flower);
        }
        if (accessor.accessor$getGrassPerChunk() > 0) {
            Shrub grass = Shrub.builder().perChunk(accessor.accessor$getGrassPerChunk() * 128).type(ShrubTypes.TALL_GRASS, 1).build();
            gensettings.getPopulators().add(grass);
        }
        if (accessor.accessor$getDeadBushPerChunk() > 0) {
            DeadBush deadBush = DeadBush.builder().perChunk(accessor.accessor$getDeadBushPerChunk()).build();
            gensettings.getPopulators().add(deadBush);
        }
        if (accessor.accessor$getWaterLilyPerChunk() > 0) {
            WaterLily waterLily = WaterLily.builder().perChunk(accessor.accessor$getWaterLilyPerChunk() * 10).build();
            gensettings.getPopulators().add(waterLily);
        }
        ChanceTable<MushroomType> types = new ChanceTable<MushroomType>();
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.BROWN, 2.0));
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.RED, 1.0));
        types.add(new EmptyObject(5.0));
        Mushroom smallMushroom = Mushroom.builder().types(types).mushroomsPerChunk(accessor.accessor$getMushroomsPerChunk() + 1).build();
        gensettings.getPopulators().add(smallMushroom);
        Reed reed = Reed.builder().perChunk(accessor.accessor$getReedsPerChunk() + 10).reedHeight(VariableAmount.baseWithRandomAddition(2.0, VariableAmount.baseWithRandomAddition(1.0, 3.0))).build();
        gensettings.getPopulators().add(reed);
        Pumpkin pumpkin = Pumpkin.builder().perChunk(64).chance(0.03125).build();
        gensettings.getPopulators().add(pumpkin);
        if (accessor.accessor$getCactiPerChunk() > 0) {
            Cactus cactus = Cactus.builder().cactiPerChunk(VariableAmount.baseWithOptionalAddition(0.0, VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithOptionalAddition(2.0, 3.0, 0.5)), 0.8)).build();
            gensettings.getPopulators().add(cactus);
        }
        if (decorator.field_76808_K) {
            RandomBlock water = RandomBlock.builder().block((BlockState)Blocks.field_150358_i.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(8.0, 248.0))).perChunk(50).placementTarget(CAVE_LIQUIDS).build();
            gensettings.getPopulators().add(water);
            RandomBlock lava = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(8.0, VariableAmount.baseWithRandomAddition(8.0, 240.0)))).perChunk(20).placementTarget(CAVE_LIQUIDS).build();
            gensettings.getPopulators().add(lava);
        }
    }

    public static void resetGrassAndFlowers(BiomeDecorator decorator) {
        ((BiomeDecoratorAccessor)decorator).accessor$setFlowersPerChunk(0);
        ((BiomeDecoratorAccessor)decorator).accessor$setGrassPerChunk(0);
    }

    public static void buildHellPopulators(net.minecraft.world.World world, SpongeBiomeGenerationSettings gensettings) {
        RandomBlock lava1 = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).perChunk(8).height(VariableAmount.baseWithRandomAddition(4.0, 120.0)).placementTarget(HELL_LAVA).build();
        gensettings.getPopulators().add(lava1);
        NetherFire fire = NetherFire.builder().perChunk(VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithRandomAddition(1.0, 10.0))).perCluster(64).build();
        gensettings.getPopulators().add(fire);
        Glowstone glowstone1 = Glowstone.builder().blocksPerCluster(1500).clusterHeight(VariableAmount.baseWithRandomAddition(-11.0, 12.0)).perChunk(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(1.0, 10.0))).height(VariableAmount.baseWithRandomAddition(4.0, 120.0)).build();
        gensettings.getPopulators().add(glowstone1);
        Glowstone glowstone2 = Glowstone.builder().blocksPerCluster(1500).clusterHeight(VariableAmount.baseWithRandomAddition(0.0, 12.0)).perChunk(10).height(VariableAmount.baseWithRandomAddition(0.0, 128.0)).build();
        gensettings.getPopulators().add(glowstone2);
        ChanceTable<MushroomType> types = new ChanceTable<MushroomType>();
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.BROWN, 1.0));
        types.add(new EmptyObject(1.0));
        HellMushroomPopulator smallMushroom = new HellMushroomPopulator();
        smallMushroom.setMushroomsPerChunk(1);
        smallMushroom.getTypes().addAll((Collection<TableEntry<MushroomType>>)types);
        gensettings.getPopulators().add(smallMushroom);
        ChanceTable<MushroomType> types2 = new ChanceTable<MushroomType>();
        types2.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.RED, 1.0));
        types2.add(new EmptyObject(1.0));
        HellMushroomPopulator smallMushroom2 = new HellMushroomPopulator();
        smallMushroom2.setMushroomsPerChunk(1);
        smallMushroom2.getTypes().addAll((Collection<TableEntry<MushroomType>>)types2);
        gensettings.getPopulators().add(smallMushroom2);
        Ore quartz = Ore.builder().height(VariableAmount.baseWithRandomAddition(10.0, 108.0)).ore(BlockTypes.QUARTZ_ORE.getDefaultState()).perChunk(16).placementCondition(o -> o != null && o.getType() == BlockTypes.NETHERRACK).size(14).build();
        gensettings.getPopulators().add(quartz);
        int halfSeaLevel = world.func_181545_F() / 2 + 1;
        Ore magma = Ore.builder().height(VariableAmount.baseWithRandomAddition((double)(halfSeaLevel - 5), 10.0)).ore(BlockTypes.MAGMA.getDefaultState()).perChunk(4).placementCondition(o -> o != null && o.getType() == BlockTypes.NETHERRACK).size(33).build();
        gensettings.getPopulators().add(magma);
        RandomBlock lava2 = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).perChunk(16).height(VariableAmount.baseWithRandomAddition(10.0, 108.0)).placementTarget(HELL_LAVA_ENCLOSED).build();
        gensettings.getPopulators().add(lava2);
    }

    public static void buildForestPopulators(SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator, BiomeForest.Type type) {
        Object forest;
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        if (type == BiomeForest.Type.ROOFED) {
            forest = new RoofedForestPopulator();
            gensettings.getPopulators().add(0, (Populator)forest);
        } else {
            forest = Forest.builder();
            forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1));
            if (type == BiomeForest.Type.BIRCH) {
                forest.type(BiomeTreeTypes.BIRCH.getPopulatorObject(), 1.0);
            } else {
                forest.type(BiomeTreeTypes.OAK.getPopulatorObject(), 4.0);
                forest.type(BiomeTreeTypes.BIRCH.getPopulatorObject(), 1.0);
            }
            gensettings.getPopulators().add(0, forest.build());
        }
        if (type == BiomeForest.Type.FLOWER) {
            gensettings.getPopulators().removeAll(gensettings.getPopulators(Flower.class));
            Flower flower = Flower.builder().perChunk(accessor.accessor$getFlowersPerChunk() * 64).supplier(new FlowerForestSupplier()).build();
            gensettings.getPopulators().add(flower);
        }
    }

    public static void buildHillsPopulator(SpongeBiomeGenerationSettings gensettings, BiomeHills.Type type, BiomeDecorator decorator) {
        gensettings.getGroundCoverLayers().clear();
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer(stoneNoise -> {
            IBlockState result = Blocks.field_150349_c.func_176223_P();
            if ((stoneNoise < -1.0 || stoneNoise > 2.0) && type == BiomeHills.Type.MUTATED) {
                result = Blocks.field_150351_n.func_176223_P();
            } else if (stoneNoise > 1.0 && type != BiomeHills.Type.EXTRA_TREES) {
                result = Blocks.field_150348_b.func_176223_P();
            }
            return (BlockState)result;
        }, SeededVariableAmount.fixed(1.0)));
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer(stoneNoise -> {
            IBlockState result = Blocks.field_150346_d.func_176223_P();
            if ((stoneNoise < -1.0 || stoneNoise > 2.0) && type == BiomeHills.Type.MUTATED) {
                result = Blocks.field_150351_n.func_176223_P();
            } else if (stoneNoise > 1.0 && type != BiomeHills.Type.EXTRA_TREES) {
                result = Blocks.field_150348_b.func_176223_P();
            }
            return (BlockState)result;
        }, GROUND_COVER_DEPTH));
        RandomBlock emerald = RandomBlock.builder().block((BlockState)Blocks.field_150412_bA.func_176223_P()).placementTarget(STONE_LOCATION).perChunk(VariableAmount.baseWithRandomAddition(3.0, 6.0)).height(VariableAmount.baseWithRandomAddition(4.0, 28.0)).build();
        gensettings.getPopulators().add(emerald);
        Ore silverfish = Ore.builder().ore((BlockState)Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONE)).perChunk(7).height(VariableAmount.baseWithRandomAddition(0.0, 64.0)).size(9).build();
        gensettings.getPopulators().add(silverfish);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)((BiomeDecoratorAccessor)decorator).accessor$getTreesPerChunk(), 1.0, 0.1));
        forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 20.0);
        forest.type(BiomeTreeTypes.OAK.getPopulatorObject(), 9.0);
        forest.type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0);
        gensettings.getPopulators().add(0, forest.build());
    }

    public static void buildJunglePopulators(SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator, boolean isEdge) {
        Iterator<Populator> it = gensettings.getPopulators().iterator();
        while (it.hasNext()) {
            TableEntry entry;
            Shrub s;
            Populator next = it.next();
            if (!(next instanceof Shrub) || (s = (Shrub)next).getTypes().size() != 1 || !((entry = s.getTypes().getEntries().get(0)) instanceof WeightedObject) || ((WeightedObject)entry).get() != ShrubTypes.TALL_GRASS) continue;
            it.remove();
        }
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        Shrub grass = Shrub.builder().perChunk(accessor.accessor$getGrassPerChunk() * 128).type(ShrubTypes.FERN, 1).type(ShrubTypes.TALL_GRASS, 3).build();
        gensettings.getPopulators().add(grass);
        Melon melon = Melon.builder().perChunk(64).build();
        gensettings.getPopulators().add(melon);
        Vine vine = Vine.builder().perChunk(50).build();
        gensettings.getPopulators().add(vine);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1));
        forest.type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0);
        forest.type(BiomeTreeTypes.JUNGLE_BUSH.getPopulatorObject(), 4.5);
        if (!isEdge) {
            forest.type(BiomeTreeTypes.JUNGLE.getLargePopulatorObject().get(), 1.2);
            forest.type(BiomeTreeTypes.JUNGLE.getPopulatorObject(), 3.0);
        } else {
            forest.type(BiomeTreeTypes.JUNGLE.getPopulatorObject(), 4.5);
        }
        gensettings.getPopulators().add(0, forest.build());
    }

    public static void buildMesaPopulators(net.minecraft.world.World world, SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator) {
        String s = world.func_72912_H().func_82571_y();
        ChunkGeneratorSettings settings = ChunkGeneratorSettings.Factory.func_177865_a((String)s).func_177864_b();
        Ore gold = Ore.builder().ore((BlockState)Blocks.field_150352_o.func_176223_P()).size(settings.field_177828_ak).perChunk(20).height(VariableAmount.baseWithRandomAddition(32.0, 48.0)).build();
        gensettings.getPopulators().add(gold);
        gensettings.getGroundCoverLayers().clear();
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest forest = Forest.builder().perChunk(VariableAmount.baseWithOptionalAddition((double)((BiomeDecoratorAccessor)decorator).accessor$getTreesPerChunk(), 1.0, 0.1)).type(BiomeTreeTypes.OAK.getPopulatorObject(), 1.0).build();
        gensettings.getPopulators().add(0, forest);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Cactus.class));
        Cactus cactus = Cactus.builder().cactiPerChunk(VariableAmount.baseWithOptionalAddition(0.0, VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithOptionalAddition(2.0, 3.0, 0.25)), 0.4)).build();
        gensettings.getPopulators().add(cactus);
    }

    public static void buildSavanaPopulators(SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator) {
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1));
        forest.type(BiomeTreeTypes.OAK.getPopulatorObject(), 1.0);
        forest.type(BiomeTreeTypes.SAVANNA.getPopulatorObject(), 4.0);
        gensettings.getPopulators().add(0, forest.build());
    }

    public static void buildSnowPopulators(SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator) {
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 2.0, 0.1));
        forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 1.0);
        gensettings.getPopulators().add(0, forest.build());
    }

    public static void buildSwampPopulators(SpongeBiomeGenerationSettings gensettings, BiomeDecorator decorator) {
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1));
        forest.type(BiomeTreeTypes.SWAMP.getPopulatorObject(), 1.0);
        gensettings.getPopulators().add(0, forest.build());
        gensettings.getPopulators().add(Fossil.builder().probability(0.015625).build());
    }

    public static void buildTaigaPopulators(SpongeBiomeGenerationSettings gensettings, BiomeTaiga.Type type, IBlockState fillerBlock, BiomeDecorator decorator) {
        if (type == BiomeTaiga.Type.MEGA || type == BiomeTaiga.Type.MEGA_SPRUCE) {
            gensettings.getGroundCoverLayers().clear();
            gensettings.getGroundCoverLayers().add(new GroundCoverLayer(seed -> {
                if (seed > 1.75) {
                    return (BlockState)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
                }
                if (seed > -0.95) {
                    return (BlockState)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
                }
                return (BlockState)Blocks.field_150349_c.func_176223_P();
            }, GROUND_COVER_DEPTH));
            gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)fillerBlock, GROUND_COVER_DEPTH));
        }
        BiomeDecoratorAccessor accessor = (BiomeDecoratorAccessor)decorator;
        Iterator<Shrub> it = gensettings.getPopulators(Shrub.class).iterator();
        while (it.hasNext()) {
            TableEntry entry;
            Shrub next = it.next();
            if (next.getTypes().size() != 1 || !((entry = next.getTypes().getEntries().get(0)) instanceof WeightedObject) || ((WeightedObject)entry).get() != ShrubTypes.TALL_GRASS) continue;
            it.remove();
        }
        Shrub grass = Shrub.builder().perChunk(accessor.accessor$getGrassPerChunk() * 128).type(ShrubTypes.FERN, 4).type(ShrubTypes.TALL_GRASS, 1).build();
        gensettings.getPopulators().add(grass);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)accessor.accessor$getTreesPerChunk(), 1.0, 0.1));
        if (type == BiomeTaiga.Type.MEGA || type == BiomeTaiga.Type.MEGA_SPRUCE) {
            if (type == BiomeTaiga.Type.MEGA) {
                forest.type(BiomeTreeTypes.POINTY_TAIGA.getLargePopulatorObject().get(), 1.0);
                forest.type(BiomeTreeTypes.TALL_TAIGA.getLargePopulatorObject().get(), 12.0);
            } else {
                forest.type(BiomeTreeTypes.TALL_TAIGA.getLargePopulatorObject().get(), 13.0);
            }
            forest.type(BiomeTreeTypes.POINTY_TAIGA.getPopulatorObject(), 8.666666666666666);
            forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 17.333333333333332);
        } else {
            forest.type(BiomeTreeTypes.POINTY_TAIGA.getPopulatorObject(), 1.0);
            forest.type(BiomeTreeTypes.TALL_TAIGA.getPopulatorObject(), 2.0);
        }
        gensettings.getPopulators().add(0, forest.build());
    }
}

