/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensCollection;
import org.spongepowered.common.item.inventory.lens.impl.collections.MutableLensCollectionImpl;
import org.spongepowered.common.item.inventory.lens.impl.struct.LensHandle;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public abstract class AbstractLens
implements Lens {
    protected final Class<? extends Inventory> adapterType;
    protected final int base;
    protected final IntSet availableSlots = new IntOpenHashSet();
    protected Lens parent;
    protected MutableLensCollection children;
    protected List<LensHandle> spanningChildren;
    protected int size;
    private int maxOrdinal = 0;

    public AbstractLens(int base, int size, Class<? extends Inventory> adapterType) {
        Preconditions.checkArgument((base >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (int)base);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s", (int)size);
        Preconditions.checkNotNull(adapterType, (Object)"adapterType");
        this.base = base;
        this.size = size;
        this.adapterType = adapterType;
        this.children = new MutableLensCollectionImpl(0, false);
        this.spanningChildren = new ArrayList<LensHandle>();
    }

    protected void addChild(Lens lens, InventoryProperty<?, ?> ... properties) {
        Preconditions.checkNotNull((Object)lens, (Object)"Attempted to register a null lens");
        this.children.add(lens, properties);
        this.availableSlots.addAll((IntCollection)lens.getSlots());
    }

    protected void addSpanningChild(Lens lens, InventoryProperty<?, ?> ... properties) {
        this.addChild(lens, properties);
        LensHandle child = new LensHandle(lens, properties);
        this.spanningChildren.add(child);
        child.ordinal = this.maxOrdinal;
        this.maxOrdinal += lens.getSlots().size();
        if (lens instanceof AbstractLens) {
            ((AbstractLens)lens).setParent(this);
        }
    }

    protected void setParent(Lens parent) {
        this.parent = parent;
    }

    @Override
    public Translation getName(Fabric inv) {
        return inv.fabric$getDisplayName();
    }

    @Override
    public Lens getParent() {
        return this.parent;
    }

    @Override
    public IntSet getSlots() {
        return IntSets.unmodifiable((IntSet)this.availableSlots);
    }

    @Override
    public boolean hasSlot(int index) {
        return this.availableSlots.contains(index);
    }

    @Override
    public Class<? extends Inventory> getAdapterType() {
        return this.adapterType;
    }

    @Override
    public ItemStack getStack(Fabric inv, int ordinal) {
        LensHandle lens = this.getLensForOrdinal(ordinal);
        if (lens == null) {
            return ItemStack.field_190927_a;
        }
        return lens.lens.getStack(inv, ordinal - lens.ordinal);
    }

    @Override
    public boolean setStack(Fabric inv, int ordinal, ItemStack stack) {
        LensHandle lens = this.getLensForOrdinal(ordinal);
        return lens != null && lens.lens.setStack(inv, ordinal - lens.ordinal, stack);
    }

    protected LensHandle getLensForOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > this.maxOrdinal) {
            return null;
        }
        for (LensHandle child : this.spanningChildren) {
            if (child.ordinal > ordinal || ordinal - child.ordinal >= child.lens.slotCount()) continue;
            return child;
        }
        return null;
    }

    @Override
    public SlotLens getSlotLens(int ordinal) {
        LensHandle handle = this.getLensForOrdinal(ordinal);
        if (handle == null) {
            return null;
        }
        return handle.lens.getSlotLens(ordinal - handle.ordinal);
    }

    @Override
    public List<Lens> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<Lens> getSpanningChildren() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (LensHandle child : this.spanningChildren) {
            listBuilder.add((Object)child.lens);
        }
        return listBuilder.build();
    }

    @Override
    public int slotCount() {
        return this.size;
    }

    @Override
    public Lens getLens(int index) {
        return this.children.getLens(index);
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(int index) {
        return this.children.getProperties(index);
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(Lens child) {
        int index = this.children.indexOf(child);
        if (index < 0) {
            throw new NoSuchElementException("Specified child lens is not a direct descendant this lens");
        }
        return this.children.getProperties(index);
    }

    @Override
    public boolean has(Lens lens) {
        return this.children.contains(lens);
    }

    @Override
    public boolean isSubsetOf(Collection<Lens> c) {
        return this.children.isSubsetOf(c);
    }

    @Override
    public Iterator<Lens> iterator() {
        return this.children.iterator();
    }

    @Override
    public int getRealIndex(Fabric inv, int ordinal) {
        LensHandle child = this.getLensForOrdinal(ordinal);
        return child.lens.getRealIndex(inv, ordinal - child.ordinal);
    }

    @Override
    public int getMaxStackSize(Fabric inv) {
        return inv.fabric$getMaxStackSize();
    }

    protected boolean checkOrdinal(int ordinal) {
        return ordinal >= 0 && ordinal < this.size;
    }
}

