/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.entity.EntityItemBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class InfinitePickupDelayValueProcessor
extends AbstractSpongeValueProcessor<EntityItem, Boolean, Value<Boolean>> {
    public InfinitePickupDelayValueProcessor() {
        super(EntityItem.class, Keys.INFINITE_PICKUP_DELAY);
    }

    @Override
    public Value<Boolean> constructValue(Boolean defaultValue) {
        return new SpongeValue<Boolean>(Keys.INFINITE_PICKUP_DELAY, false, defaultValue);
    }

    @Override
    protected boolean set(EntityItem container, Boolean value) {
        ((EntityItemBridge)container).bridge$setPickupDelay(value != false ? Short.MAX_VALUE : 0, value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityItem container) {
        return Optional.of(((EntityItemBridge)container).bridge$infinitePickupDelay());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected boolean supports(EntityItem container) {
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

