/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDisabledSlotsData;
import org.spongepowered.api.data.manipulator.mutable.entity.DisabledSlotsData;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.equipment.WornEquipmentType;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDisabledSlotsData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;
import org.spongepowered.common.mixin.core.entity.item.EntityArmorStandAccessor;

public class DisabledSlotsDataProcessor
extends AbstractMultiDataSingleTargetProcessor<EntityArmorStandAccessor, DisabledSlotsData, ImmutableDisabledSlotsData> {
    public DisabledSlotsDataProcessor() {
        super(EntityArmorStandAccessor.class);
    }

    private int populateChunkFromSet(Set<EquipmentType> value) {
        int chunk = 0;
        if (value.contains(EquipmentTypes.BOOTS)) {
            chunk |= 2;
        }
        if (value.contains(EquipmentTypes.LEGGINGS)) {
            chunk |= 4;
        }
        if (value.contains(EquipmentTypes.CHESTPLATE)) {
            chunk |= 8;
        }
        if (value.contains(EquipmentTypes.HEADWEAR)) {
            chunk |= 0x10;
        }
        return chunk;
    }

    @Override
    protected boolean doesDataExist(EntityArmorStandAccessor dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityArmorStandAccessor dataHolder, Map<Key<?>, Object> keyValues) {
        int disabledSlots = 0;
        if (keyValues.containsKey(Keys.ARMOR_STAND_TAKING_DISABLED)) {
            Set takingDisabled = (Set)keyValues.get(Keys.ARMOR_STAND_TAKING_DISABLED);
            disabledSlots |= this.populateChunkFromSet(takingDisabled) << 8;
        }
        if (keyValues.containsKey(Keys.ARMOR_STAND_PLACING_DISABLED)) {
            Set placingDisabled = (Set)keyValues.get(Keys.ARMOR_STAND_PLACING_DISABLED);
            disabledSlots |= this.populateChunkFromSet(placingDisabled) << 16;
        }
        dataHolder.accessor$setDisabledSlots(disabledSlots);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityArmorStandAccessor dataHolder) {
        int disabledSlotsValue = dataHolder.accessor$getDisabledSlots();
        int allChunk = disabledSlotsValue & 0xFF;
        if (allChunk != 0) {
            disabledSlotsValue |= allChunk << 8;
            disabledSlotsValue |= allChunk << 16;
            dataHolder.accessor$setDisabledSlots(disabledSlotsValue ^= 0xFF);
        }
        int disabledSlots = dataHolder.accessor$getDisabledSlots();
        HashSet<WornEquipmentType> takingDisabled = new HashSet<WornEquipmentType>();
        if ((disabledSlots >> 9 & 1) != 0) {
            takingDisabled.add(EquipmentTypes.BOOTS);
        }
        if ((disabledSlots >> 10 & 1) != 0) {
            takingDisabled.add(EquipmentTypes.LEGGINGS);
        }
        if ((disabledSlots >> 11 & 1) != 0) {
            takingDisabled.add(EquipmentTypes.CHESTPLATE);
        }
        if ((disabledSlots >> 12 & 1) != 0) {
            takingDisabled.add(EquipmentTypes.HEADWEAR);
        }
        HashSet<WornEquipmentType> placingDisabled = new HashSet<WornEquipmentType>();
        if ((disabledSlots >> 17 & 1) != 0) {
            placingDisabled.add(EquipmentTypes.BOOTS);
        }
        if ((disabledSlots >> 18 & 1) != 0) {
            placingDisabled.add(EquipmentTypes.LEGGINGS);
        }
        if ((disabledSlots >> 19 & 1) != 0) {
            placingDisabled.add(EquipmentTypes.CHESTPLATE);
        }
        if ((disabledSlots >> 20 & 1) != 0) {
            placingDisabled.add(EquipmentTypes.HEADWEAR);
        }
        return ImmutableMap.builder().put(Keys.ARMOR_STAND_PLACING_DISABLED, placingDisabled).put(Keys.ARMOR_STAND_TAKING_DISABLED, takingDisabled).build();
    }

    @Override
    protected DisabledSlotsData createManipulator() {
        return new SpongeDisabledSlotsData();
    }

    @Override
    public Optional<DisabledSlotsData> fill(DataContainer container, DisabledSlotsData disabledSlotsData) {
        if (container.contains(Keys.ARMOR_STAND_TAKING_DISABLED)) {
            disabledSlotsData.set(Keys.ARMOR_STAND_TAKING_DISABLED, new HashSet((Collection)container.get(Keys.ARMOR_STAND_TAKING_DISABLED.getQuery()).get()));
        }
        if (container.contains(Keys.ARMOR_STAND_PLACING_DISABLED)) {
            disabledSlotsData.set(Keys.ARMOR_STAND_PLACING_DISABLED, new HashSet((Collection)container.get(Keys.ARMOR_STAND_PLACING_DISABLED.getQuery()).get()));
        }
        return Optional.of(disabledSlotsData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

