/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.args;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.PatternMatchingCommandElement;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

public final class FilteredPluginsCommandElement
extends PatternMatchingCommandElement {
    private final Predicate<? super PluginContainer> predicate;

    public FilteredPluginsCommandElement(@Nullable Text key, Predicate<? super PluginContainer> predicate) {
        super(key);
        this.predicate = predicate;
    }

    @Override
    protected Iterable<String> getChoices(CommandSource source) {
        return Sponge.getPluginManager().getPlugins().stream().filter(this.predicate).map(PluginContainer::getId).collect(Collectors.toList());
    }

    @Override
    protected Object getValue(String choice) throws IllegalArgumentException {
        Optional<PluginContainer> plugin = Sponge.getPluginManager().getPlugin(choice);
        return plugin.orElseThrow(() -> new IllegalArgumentException("Plugin " + choice + " was not found"));
    }
}

