/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;

public interface ExtentBufferFactory {
    default public MutableBiomeVolume createBiomeBuffer(Vector3i size) {
        return this.createBiomeBuffer(Vector3i.ZERO, size);
    }

    public MutableBiomeVolume createBiomeBuffer(Vector3i var1, Vector3i var2);

    default public MutableBiomeVolume createBiomeBuffer(int xSize, int ySize, int zSize) {
        return this.createBiomeBuffer(new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBiomeVolume createBiomeBuffer(int xMin, int yMin, int zMin, int xSize, int ySize, int zSize) {
        return this.createBiomeBuffer(new Vector3i(xMin, yMin, zMin), new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBiomeVolume createThreadSafeBiomeBuffer(Vector3i size) {
        return this.createThreadSafeBiomeBuffer(Vector3i.ZERO, size);
    }

    public MutableBiomeVolume createThreadSafeBiomeBuffer(Vector3i var1, Vector3i var2);

    default public MutableBiomeVolume createThreadSafeBiomeBuffer(int xSize, int ySize, int zSize) {
        return this.createThreadSafeBiomeBuffer(new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBiomeVolume createThreadSafeBiomeBuffer(int xMin, int yMin, int zMin, int xSize, int ySize, int zSize) {
        return this.createThreadSafeBiomeBuffer(new Vector3i(xMin, yMin, zMin), new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBlockVolume createBlockBuffer(Vector3i size) {
        return this.createBlockBuffer(Vector3i.ZERO, size);
    }

    public MutableBlockVolume createBlockBuffer(Vector3i var1, Vector3i var2);

    default public MutableBlockVolume createBlockBuffer(int xSize, int ySize, int zSize) {
        return this.createBlockBuffer(new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBlockVolume createBlockBuffer(int xMin, int yMin, int zMin, int xSize, int ySize, int zSize) {
        return this.createBlockBuffer(new Vector3i(xMin, yMin, zMin), new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBlockVolume createThreadSafeBlockBuffer(Vector3i size) {
        return this.createThreadSafeBlockBuffer(Vector3i.ZERO, size);
    }

    public MutableBlockVolume createThreadSafeBlockBuffer(Vector3i var1, Vector3i var2);

    default public MutableBlockVolume createThreadSafeBlockBuffer(int xSize, int ySize, int zSize) {
        return this.createThreadSafeBlockBuffer(new Vector3i(xSize, ySize, zSize));
    }

    default public MutableBlockVolume createThreadSafeBlockBuffer(int xMin, int yMin, int zMin, int xSize, int ySize, int zSize) {
        return this.createThreadSafeBlockBuffer(new Vector3i(xMin, yMin, zMin), new Vector3i(xSize, ySize, zSize));
    }

    public ArchetypeVolume createArchetypeVolume(Vector3i var1, Vector3i var2);

    default public ArchetypeVolume createArchetypeVolume(Vector3i size) {
        return this.createArchetypeVolume(size, Vector3i.ZERO);
    }
}

