/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.gc.features;

import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.romvoid95.gctweaks.base.Feature;

public class DimensionalComets
extends Feature {
    private static boolean cometModification;
    private static String[] dimensionID_spawnrate;

    @Override
    public String category() {
        return "dimensionComets";
    }

    @Override
    public String comment() {
        return ">> INFO: Comets will not be allowed to spawn in the Nether <<\nspecify where and how often asteroids will drop in set dimensions\nsee file under `config\\GalacticTweaks\\ValidDimensions.txt` for valid dimension ID's\n";
    }

    @Override
    public void syncConfig(String category) {
        cometModification = this.set(category, "enableFeature", false);
        dimensionID_spawnrate = this.set(category, "cometData", "Data consisting of which Dimensions meteors will spawn in and the spawn-rate modification value.\nSpec: <dimID:rate> (Ex: -29:3.5)", new String[]{"0:1.0", "1:2.0"});
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving;
        if (cometModification && (entityLiving = event.getEntityLiving()) instanceof EntityPlayerMP) {
            this.onPlayerUpdate((EntityPlayerMP)entityLiving);
        }
    }

    private void onPlayerUpdate(EntityPlayerMP player) {
        for (String data : dimensionID_spawnrate) {
            int dimId = Integer.parseInt(data.split(":")[0]);
            double spawnRate = Double.parseDouble(data.split(":")[1]);
            this.meteors(player, dimId, spawnRate);
        }
    }

    protected void meteors(EntityPlayerMP player, int dimensionid, double spawnRate) {
        World world = player.field_70170_p;
        if (world.field_73011_w.func_186058_p().func_186068_a() == -1) {
            return;
        }
        if (world.field_73011_w.func_186058_p().func_186068_a() == dimensionid && !world.field_72995_K) {
            EntityMeteor meteor;
            int px;
            double motZ;
            double motX;
            int z;
            int x;
            EntityPlayer closestPlayer;
            int f;
            if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
                IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)world.field_73011_w;
                double x2 = provider.getMeteorFrequency();
                f = (int)((provider.getMeteorFrequency() - x2) * 750.0 * (1.0 / spawnRate));
            } else {
                f = (int)(750.0 * (1.0 / spawnRate));
            }
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                int r = world.func_73046_m().func_184103_al().func_72395_o();
                x = world.field_73012_v.nextInt(20) + 160;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
                motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
                px = MathHelper.func_76128_c((double)player.field_70165_t);
                if ((x + px >> 4) - (px >> 4) >= r) {
                    x = ((px >> 4) + r << 4) - 1 - px;
                }
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX, 0.0, motZ, 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                int r = world.func_73046_m().func_184103_al().func_72395_o();
                x = world.field_73012_v.nextInt(20) + 160;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
                motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
                px = MathHelper.func_76128_c((double)player.field_70165_t);
                if ((x + px >> 4) - (px >> 4) >= r) {
                    x = ((px >> 4) + r << 4) - 1 - px;
                }
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX, 0.0, motZ, 6);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
        }
    }
}

