/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.romvoid95.gctweaks.GalacticTweaks;
import net.romvoid95.gctweaks.base.Feature;
import net.romvoid95.gctweaks.base.core.ConfigBase;

public abstract class Module {
    private List<Feature> features = new ArrayList<Feature>();
    private String name;
    public static ConfigBase config;
    private ConfigBase.ConfigVersion cfgVersion = new ConfigBase.ConfigVersion(1, 1, 0);
    private boolean setConfig;

    public Module(String name) {
        this.setConfig = true;
        this.name = name;
        this.addFeatures();
    }

    public Module() {
        this.setConfig = false;
        this.addFeatures();
    }

    public abstract void addFeatures();

    public void preInit() {
        this.features.stream().filter(Feature::usesEvents).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.features.forEach(Feature::preInit);
    }

    public void proxyPreInit() {
        this.features.stream().filter(Feature::sidedProxy).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.features.forEach(Feature::proxyPreInit);
    }

    public void setupConfig(FMLPreInitializationEvent event) {
        if (this.setConfig) {
            File file = new File(event.getModConfigurationDirectory().toString() + "/GalacticTweaks/" + this.name + ".cfg");
            config = new ConfigBase(file, this.cfgVersion);
            ConfigManager.sync((String)"gctweaks", (Config.Type)Config.Type.INSTANCE);
            config.getConfig().load();
        }
    }

    public void init() {
        this.features.forEach(Feature::init);
    }

    public void postInit() {
        this.features.forEach(Feature::postInit);
    }

    public void proxyInit() {
        this.features.forEach(Feature::proxyInit);
    }

    public void proxyPostInit() {
        this.features.forEach(Feature::proxyPostInit);
    }

    public void serverStartingEvent(FMLServerStartingEvent event) {
        this.features.forEach(feature -> feature.ServerStartingEvent(event));
    }

    public Configuration getConfig() {
        return config.getConfig();
    }

    public void syncConfig() {
        this.features.forEach(feature -> {
            feature.syncConfig(feature.category());
            config.addElement(feature.category());
            config.getConfig().addCustomCategoryComment(feature.category(), feature.comment());
            config.getConfig().setCategoryPropertyOrder(feature.category(), feature.propOrder);
            if (config.getConfig().hasChanged()) {
                config.getConfig().save();
            }
        });
    }

    protected void registerFeature(Feature feature) {
        this.features.add(feature);
    }

    public void registerPacket() {
        this.features.forEach(feature -> feature.registerPacket(GalacticTweaks.network));
    }
}

