/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs4.api.TileEntityModule;
import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.plugins.vanilla.crafting.ItemHandlerMachine;
import cubex2.cs4.plugins.vanilla.crafting.MachineFuel;
import cubex2.cs4.plugins.vanilla.crafting.MachineManager;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipe;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import cubex2.cs4.plugins.vanilla.gui.FluidSource;
import cubex2.cs4.plugins.vanilla.gui.ProgressBarSource;
import cubex2.cs4.util.CollectionHelper;
import cubex2.cs4.util.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityModuleMachine
implements TileEntityModule,
ProgressBarSource {
    private final ItemHandlerMachine invHandler;
    private final Supplier supplier;
    private final TileEntity tile;
    private final FluidSource fluidSource;
    private int burnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private final Map<EnumFacing, IItemHandler> itemHandlers = Maps.newHashMap();

    public TileEntityModuleMachine(TileEntity tile, Supplier supplier) {
        this.invHandler = new ItemHandlerMachine(supplier.inputSlots, supplier.outputSlots, supplier.fuelSlots, tile);
        this.tile = tile;
        this.supplier = supplier;
        this.fluidSource = tile instanceof FluidSource ? n -> Optional.ofNullable(((FluidSource)tile).getFluidTank(n)).orElse((IFluidTank)EmptyFluidHandler.INSTANCE) : n -> EmptyFluidHandler.INSTANCE;
        for (EnumFacing facing : EnumFacing.values()) {
            this.handlerForSide(facing).ifPresent(h -> this.itemHandlers.put(facing, (IItemHandler)h));
        }
    }

    private Optional<IItemHandler> handlerForSide(EnumFacing facing) {
        ArrayList handlers = Lists.newArrayList();
        if (ArrayUtils.contains((Object[])this.supplier.sidesInput, (Object)facing)) {
            handlers.add(this.invHandler.getInputHandler());
        }
        if (ArrayUtils.contains((Object[])this.supplier.sidesOutput, (Object)facing)) {
            handlers.add(this.invHandler.getOutputHandler());
        }
        if (ArrayUtils.contains((Object[])this.supplier.sidesFuel, (Object)facing)) {
            handlers.add(this.invHandler.getFuelHandler());
        }
        return Optional.ofNullable(handlers.isEmpty() ? null : new CombinedInvWrapper(handlers.toArray(new IItemHandlerModifiable[handlers.size()])));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.invHandler.deserializeNBT(compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("TotalCookTime");
        this.currentItemBurnTime = this.getActiveFuel().getBurnTime();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = this.invHandler.serializeNBT();
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("TotalCookTime", this.totalCookTime);
        return compound;
    }

    @Override
    public void update() {
        if (!this.tile.func_145831_w().field_72995_K) {
            if (this.isBurning() && this.needsFuel()) {
                --this.burnTime;
            }
            if (!this.isBurning() && this.canSmelt() && this.needsFuel()) {
                this.burnFuel();
            }
            if ((this.isBurning() || !this.needsFuel()) && this.canSmelt()) {
                ++this.cookTime;
                if (this.totalCookTime == 0) {
                    this.totalCookTime = this.getCookTime();
                }
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 0;
                    this.totalCookTime = this.getCookTime();
                    this.smelt();
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    private void smelt() {
        if (this.canSmelt()) {
            MachineRecipe recipe = this.getActiveRecipe();
            MachineRecipeOutput output = this.selectRecipeOutput(recipe);
            this.smeltItems(recipe, output);
            this.smeltFluids(recipe, output);
        }
    }

    private MachineRecipeOutput selectRecipeOutput(MachineRecipe recipe) {
        List available = recipe.getOutputs().stream().filter(this::doesRecipeOutputFitInMachine).collect(Collectors.toList());
        Optional<MachineRecipeOutput> output = CollectionHelper.randomElement(available, MachineRecipeOutput::getWeight);
        return output.orElse(MachineRecipeOutput.EMPTY);
    }

    private void smeltFluids(MachineRecipe recipe, MachineRecipeOutput output) {
        List<FluidStack> resultFluids = output.getResultFluids();
        for (int i = 0; i < resultFluids.size(); ++i) {
            FluidStack stack = resultFluids.get(i);
            this.fluidSource.getFluidTank(this.supplier.outputTanks[i]).fill(stack, true);
        }
        this.extractInputFluids(recipe);
    }

    private void extractInputFluids(MachineRecipe recipe) {
        List remaining = Arrays.stream(this.supplier.inputTanks).map(this.fluidSource::getFluidTank).collect(Collectors.toCollection(LinkedList::new));
        ItemHelper.extractFluidsFromTanks(remaining, recipe.getFluidRecipeInput());
    }

    private void smeltItems(MachineRecipe recipe, MachineRecipeOutput output) {
        NonNullList<ItemStack> resultItems = output.getResultItems();
        for (int i = 0; i < resultItems.size(); ++i) {
            ItemStack stack = (ItemStack)resultItems.get(i);
            this.invHandler.insertOutput(i, stack, false);
        }
        for (ItemStack stack : this.invHandler.getInputStacks()) {
            if (!this.isWetSponge(stack)) continue;
            this.fillBucketWithWater();
        }
        this.invHandler.removeInputsFromInput(recipe.getRecipeInput());
    }

    private void fillBucketWithWater() {
        for (int i = 0; i < this.supplier.fuelSlots; ++i) {
            ItemStack extracted = this.invHandler.getFuelHandler().extractItem(i, 1, true);
            if (extracted.func_190926_b() || extracted.func_77973_b() != Items.field_151133_ar) continue;
            this.invHandler.getFuelHandler().setStackInSlot(i, new ItemStack(Items.field_151131_as));
        }
    }

    private boolean isWetSponge(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && stack.func_77960_j() == 1;
    }

    private boolean needsFuel() {
        return this.supplier.fuelSlots > 0;
    }

    private void burnFuel() {
        MachineFuel fuel = this.getActiveFuel();
        this.currentItemBurnTime = this.burnTime = fuel.getBurnTime();
        if (this.isBurning()) {
            this.invHandler.removeInputsFromFuel(fuel.getFuelInput());
        }
    }

    private MachineFuel getActiveFuel() {
        return MachineManager.findMatchingFuel(this.supplier.fuelList, this.invHandler.getFuelStacks());
    }

    private boolean canSmelt() {
        MachineRecipe recipe = this.getActiveRecipe();
        NonNullList<MachineRecipeOutput> outputs = recipe.getOutputs();
        return outputs.stream().anyMatch(this::doesRecipeOutputFitInMachine);
    }

    private boolean doesRecipeOutputFitInMachine(MachineRecipeOutput output) {
        ItemStack stack;
        int i;
        NonNullList<ItemStack> recipeItems = output.getOutputItems();
        List<FluidStack> recipeFluids = output.getOutputFluids();
        if (recipeItems.isEmpty() && recipeFluids.isEmpty()) {
            return false;
        }
        for (i = 0; i < recipeItems.size(); ++i) {
            stack = (ItemStack)recipeItems.get(i);
            ItemStack inserted = this.invHandler.insertOutput(i, stack, true);
            if (inserted.func_190926_b()) continue;
            return false;
        }
        for (i = 0; i < recipeFluids.size(); ++i) {
            int inserted;
            stack = recipeFluids.get(i);
            if (stack == null || (inserted = this.fluidSource.getFluidTank(this.supplier.outputTanks[i]).fill((FluidStack)stack, false)) == stack.amount) continue;
            return false;
        }
        return true;
    }

    private MachineRecipe getActiveRecipe() {
        NonNullList<ItemStack> input = this.invHandler.getInputStacks();
        List<FluidStack> inputFluid = Arrays.stream(this.supplier.inputTanks).map(this.fluidSource::getFluidTank).map(IFluidTank::getFluid).collect(Collectors.toList());
        return MachineManager.findMatchingRecipe(this.supplier.recipeList, input, inputFluid, this.tile.func_145831_w());
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    private int getCookTime() {
        int recipeTime = this.getActiveRecipe().getCookTime();
        return recipeTime <= 0 ? this.supplier.cookTime : recipeTime;
    }

    @Override
    public int getFieldCount() {
        return 4;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    @Override
    public float getProgress(String name) {
        if (name.equals("cookTime")) {
            if (this.totalCookTime > 0) {
                return (float)this.cookTime / (float)this.totalCookTime;
            }
        } else if (name.equals("burnTime") && this.currentItemBurnTime > 0) {
            return (float)this.burnTime / (float)this.currentItemBurnTime;
        }
        return 0.0f;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || this.itemHandlers.containsKey(facing));
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)((Object)this.invHandler);
            }
            return (T)this.itemHandlers.get(facing);
        }
        return null;
    }

    public static class Supplier
    implements TileEntityModuleSupplier {
        public int inputSlots = 1;
        public int outputSlots = 1;
        public int fuelSlots = 1;
        public int cookTime = 200;
        public String[] inputTanks = new String[0];
        public String[] outputTanks = new String[0];
        public ResourceLocation recipeList = new ResourceLocation("minecraft", "vanilla");
        public ResourceLocation fuelList = new ResourceLocation("minecraft", "vanilla");
        public EnumFacing[] sidesInput = new EnumFacing[]{EnumFacing.UP};
        public EnumFacing[] sidesOutput = new EnumFacing[]{EnumFacing.DOWN};
        public EnumFacing[] sidesFuel = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};

        @Override
        public TileEntityModule createModule(TileEntity tileEntity) {
            return new TileEntityModuleMachine(tileEntity, this);
        }
    }
}

