/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.tileentity;

import cubex2.cs4.api.TileEntityModule;
import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.plugins.vanilla.tileentity.ItemHandlerTileEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityModuleInventory
implements TileEntityModule {
    private final ItemStackHandler invHandler;
    private final Supplier supplier;

    public TileEntityModuleInventory(TileEntity tile, Supplier supplier) {
        this.invHandler = new ItemHandlerTileEntity(supplier.size, tile);
        this.supplier = supplier;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.invHandler.deserializeNBT(compound);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        return this.invHandler.serializeNBT();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || ArrayUtils.contains((Object[])this.supplier.sides, (Object)facing));
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || ArrayUtils.contains((Object[])this.supplier.sides, (Object)facing))) {
            return (T)this.invHandler;
        }
        return null;
    }

    public static class Supplier
    implements TileEntityModuleSupplier {
        public int size;
        public EnumFacing[] sides = EnumFacing.values();

        @Override
        public TileEntityModule createModule(TileEntity tileEntity) {
            return new TileEntityModuleInventory(tileEntity, this);
        }
    }
}

