/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.objects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcsimonflash.sponge.activetime.managers.Storage;
import com.mcsimonflash.sponge.activetime.managers.Util;
import com.mcsimonflash.sponge.activetime.objects.TimeHolder;
import com.mcsimonflash.sponge.activetime.objects.UserReport;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.text.Text;

public class ServerReport {
    public final LocalDate from;
    public final LocalDate to;
    public final TimeHolder total = new TimeHolder();
    public final TimeHolder dailyAverage = new TimeHolder();
    public final TimeHolder weeklyAverage = new TimeHolder();
    public final TimeHolder monthlyAverage = new TimeHolder();
    public final Map<UUID, UserReport> userReports = Maps.newHashMap();
    public final List<Text> print = Lists.newArrayList();

    public ServerReport(LocalDate from, LocalDate to) {
        this.from = from;
        this.to = to;
    }

    public ServerReport generate() {
        if (this.userReports.isEmpty()) {
            Storage.generateServerReport(this);
        }
        return this;
    }

    public List<Text> print() {
        if (this.print.isEmpty()) {
            this.print.add(Util.toText("From: &b" + this.from));
            this.print.add(Util.toText("To: &b" + this.to));
            this.print.add(Util.toText("Total: &b" + Util.printTime(this.total)));
            this.print.add(Util.toText("Daily Average: &b" + Util.printTime(this.dailyAverage)));
            this.print.add(Util.toText("Weekly Average: &b" + Util.printTime(this.weeklyAverage)));
            this.print.add(Util.toText("Monthly Average: &b" + Util.printTime(this.monthlyAverage)));
            Util.addTimes(this.print, "Users: ", this.userReports.entrySet().stream().map(e -> Maps.immutableEntry((Object)((UserReport)e.getValue()).name, (Object)((UserReport)e.getValue()).total)).sorted(Comparator.comparingInt(e -> -((TimeHolder)e.getValue()).getActiveTime())).collect(Collectors.toList()), n -> n);
        }
        return this.print;
    }
}

