/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.player;

import com.mojang.authlib.GameProfile;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.chat.IChatMessage;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IFoodStats;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.entity.MCEntityItem;
import crafttweaker.mc1120.entity.MCEntityLivingBase;
import crafttweaker.mc1120.network.MessageCopyClipboard;
import crafttweaker.mc1120.network.MessageOpenBrowser;
import crafttweaker.mc1120.player.MCFoodStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;

public class MCPlayer
extends MCEntityLivingBase
implements IPlayer {
    private final EntityPlayer player;

    public MCPlayer(EntityPlayer player) {
        super((EntityLivingBase)player);
        this.player = player;
    }

    public EntityPlayer getInternal() {
        return this.player;
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public IData getData() {
        return NBTConverter.from((NBTBase)this.player.getEntityData(), true);
    }

    @Override
    public int getXP() {
        return this.player.field_71068_ca;
    }

    @Override
    public void setXP(int xp) {
        this.player.func_82242_a(-this.player.field_71068_ca);
        this.player.func_82242_a(xp);
    }

    @Override
    public void removeXP(int xp) {
        this.player.func_71023_q(-xp);
    }

    @Override
    public void update(IData data) {
        NBTConverter.updateMap(this.player.getEntityData(), data);
    }

    @Override
    public void sendChat(IChatMessage message) {
        Object internal = message.getInternal();
        if (!(internal instanceof ITextComponent)) {
            CraftTweakerAPI.logError("not a valid chat message");
            return;
        }
        ITextComponent text = (ITextComponent)internal;
        if (text.func_150260_c().length() > 30000) {
            int msgCount = (int)Math.ceil((double)text.func_150260_c().length() / 30000.0);
            CraftTweakerAPI.logWarning("Message too long, splitting into " + msgCount + " messages");
            for (int i = 0; i < msgCount; ++i) {
                this.player.func_145747_a((ITextComponent)new TextComponentString(text.func_150260_c().substring(30000 * i, Math.min(30000 * (i + 1), text.func_150260_c().length()))));
            }
        } else {
            this.player.func_145747_a(text);
        }
    }

    @Override
    public void sendChat(String message) {
        String[] words = message.split(" ");
        StringBuilder out = new StringBuilder();
        int wordsLength = words.length;
        for (int i = 0; i < wordsLength; ++i) {
            String word = words[i];
            out.append(word);
            if (i < wordsLength - 1) {
                out.append(' ');
            }
            if (out.length() <= 25000) continue;
            this.player.func_145747_a((ITextComponent)new TextComponentString(out.toString()));
            out = new StringBuilder();
        }
        if (out.length() > 0) {
            this.player.func_145747_a((ITextComponent)new TextComponentString(out.toString()));
        }
    }

    @Override
    public void sendStatusMessage(String message, boolean hotBar) {
        this.player.func_146105_b((ITextComponent)new TextComponentString(message), hotBar);
    }

    @Override
    public void sendStatusMessage(IFormattedText message, boolean hotBar) {
        this.player.func_146105_b((ITextComponent)new TextComponentString(message.getText()), hotBar);
    }

    @Override
    public int getHotbarSize() {
        return 9;
    }

    @Override
    public IItemStack getHotbarStack(int i) {
        return i < 0 || i >= 9 ? null : CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public int getInventorySize() {
        return this.player.field_71071_by.func_70302_i_();
    }

    @Override
    public IItemStack getInventoryStack(int i) {
        return CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public IItemStack getCurrentItem() {
        return CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70448_g());
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    @Override
    public boolean isAdventure() {
        return !this.player.field_71075_bZ.field_75099_e;
    }

    @Override
    public void openBrowser(String url) {
        if (this.player instanceof EntityPlayerMP) {
            CraftTweaker.NETWORK.sendTo((IMessage)new MessageOpenBrowser(url), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public void setCooldown(IItemStack item, int time) {
        this.player.func_184811_cZ().func_185145_a(CraftTweakerMC.getItemStack(item).func_77973_b(), time);
    }

    @Override
    public float getCooldown(IItemStack item) {
        return this.player.func_184811_cZ().func_185143_a(CraftTweakerMC.getItemStack(item).func_77973_b(), 0.0f);
    }

    @Override
    public void copyToClipboard(String value) {
        if (this.player instanceof EntityPlayerMP) {
            CraftTweaker.NETWORK.sendTo((IMessage)new MessageCopyClipboard(value), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((MCPlayer)other).player == this.player;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.player != null ? this.player.hashCode() : 0);
        return hash;
    }

    @Override
    public void give(IItemStack stack) {
        ItemStack itemstack = CraftTweakerMC.getItemStack(stack).func_77946_l();
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.player, (ItemStack)itemstack);
    }

    @Override
    public void teleport(Position3f pos) {
        this.player.func_70107_b((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    @Override
    public void changeDimension(int dimensionId) {
        this.player.func_184204_a(dimensionId);
    }

    @Override
    public int getScore() {
        return this.player.func_71037_bA();
    }

    @Override
    public void addScore(int amount) {
        this.player.func_85039_t(amount);
    }

    @Override
    public void setScore(int amount) {
        this.player.func_85040_s(amount);
    }

    @Override
    public IFoodStats getFoodStats() {
        return new MCFoodStats(this.player.func_71024_bL());
    }

    @Override
    public void executeCommand(String rawCommand) {
        MinecraftServer server = this.player.func_184102_h();
        if (server != null) {
            server.func_71187_D().func_71556_a((ICommandSender)this.player, rawCommand);
        }
    }

    @Override
    public boolean isDamageDisabled() {
        return this.player.field_71075_bZ.field_75102_a;
    }

    @Override
    public void setDamageDisabled(boolean disabled) {
        this.player.field_71075_bZ.field_75102_a = disabled;
    }

    @Override
    public boolean canFly() {
        return this.player.field_71075_bZ.field_75101_c;
    }

    @Override
    public void setCanFly(boolean canFly) {
        this.player.field_71075_bZ.field_75101_c = canFly;
    }

    @Override
    public boolean canEdit() {
        return this.player.field_71075_bZ.field_75099_e;
    }

    @Override
    public void setCanEdit(boolean canEdit) {
        this.player.field_71075_bZ.field_75099_e = canEdit;
    }

    @Override
    public String getUUID() {
        return EntityPlayer.func_146094_a((GameProfile)this.player.func_146103_bH()).toString().toLowerCase();
    }

    @Override
    public IEntityItem dropItem(boolean dropAll) {
        return new MCEntityItem(this.player.func_71040_bB(dropAll));
    }

    @Override
    public IEntityItem dropItem(IItemStack item) {
        return new MCEntityItem(this.player.func_71019_a(CraftTweakerMC.getItemStack(item), false));
    }
}

