/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.item.diviningrod.ItemDiviningRod;
import lumien.randomthings.item.diviningrod.RodType;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DiviningRodHandler {
    public static DiviningRodHandler INSTANCE;
    LinkedHashSet<BlockPos> positionsToCheck;
    List<Indicator> indicators;
    HashMap<Block, Color> blockColorMap = new HashMap();
    int modX;
    int modY;
    int modZ;

    public DiviningRodHandler() {
        this.positionsToCheck = new LinkedHashSet();
        this.indicators = new ArrayList<Indicator>();
        this.blockColorMap.put(Blocks.field_150365_q, new Color(20, 20, 20, 50));
        this.blockColorMap.put(Blocks.field_150366_p, new Color(211, 180, 159, 50));
        this.blockColorMap.put(Blocks.field_150352_o, new Color(246, 233, 80, 50));
        this.blockColorMap.put(Blocks.field_150369_x, new Color(5, 45, 150, 50));
        this.blockColorMap.put(Blocks.field_150450_ax, new Color(211, 1, 1, 50));
        this.blockColorMap.put(Blocks.field_150412_bA, new Color(0, 220, 0, 50));
        this.blockColorMap.put(Blocks.field_150482_ag, new Color(87, 221, 229, 50));
    }

    public boolean shouldGlow(RodType rodType) {
        return !this.indicators.isEmpty() && this.indicators.stream().anyMatch(i -> i.type == rodType);
    }

    public void render() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179097_i();
        RenderUtils.enableDefaultBlending();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        for (Indicator indicator : this.indicators) {
            float size = (1.0f - (float)indicator.duration / 160.0f) * 0.2f + 0.1f;
            Color c = indicator.color;
            RenderUtils.drawCube((float)((double)indicator.target.func_177958_n() + 0.5 - (double)(size / 2.0f)), (float)((double)indicator.target.func_177956_o() + 0.5 - (double)(size / 2.0f)), (float)((double)indicator.target.func_177952_p() + 0.5 - (double)(size / 2.0f)), size, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        GlStateManager.func_179137_b((double)playerX, (double)playerY, (double)playerZ);
        GlStateManager.func_179126_j();
    }

    public void tick() {
        World world;
        Iterator<Indicator> indicatorIterator = this.indicators.iterator();
        while (indicatorIterator.hasNext()) {
            Indicator i = indicatorIterator.next();
            --i.duration;
            if (i.duration != 0) continue;
            indicatorIterator.remove();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (world = player.field_70170_p) != null) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            ItemStack rod = ItemStack.field_190927_a;
            if (!main.func_190926_b() && main.func_77973_b() == ModItems.diviningRod) {
                rod = main;
            } else if (!off.func_190926_b() && off.func_77973_b() == ModItems.diviningRod) {
                rod = off;
            }
            if (!rod.func_190926_b()) {
                BlockPos playerPos = player.func_180425_c();
                RodType type = ItemDiviningRod.getRodType(rod);
                for (int i = 0; i < 60; ++i) {
                    ++this.modX;
                    if (this.modX == 6) {
                        this.modX = -5;
                        ++this.modZ;
                        if (this.modZ == 6) {
                            this.modZ = -5;
                            ++this.modY;
                            if (this.modY == 6) {
                                this.modY = -5;
                            }
                        }
                    }
                    BlockPos target = playerPos.func_177982_a(this.modX, this.modY, this.modZ);
                    IBlockState blockState = world.func_180495_p(target);
                    if (!world.func_175667_e(target) || !type.matches(world, target, blockState)) continue;
                    Indicator indicator = new Indicator(target, 160, type.getIndicatorColor(world, target, blockState), type);
                    this.indicators.add(indicator);
                }
            }
        }
    }

    public static DiviningRodHandler get() {
        if (INSTANCE == null) {
            INSTANCE = new DiviningRodHandler();
        }
        return INSTANCE;
    }

    private static class Indicator {
        BlockPos target;
        int duration;
        Color color;
        RodType type;

        public Indicator(BlockPos target, int duration, Color color, RodType type) {
            this.target = target;
            this.duration = duration;
            this.color = color;
            this.type = type;
        }
    }
}

