/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@RitualRegister(value="full_stomach")
public class RitualFullStomach
extends Ritual {
    public static final String FILL_RANGE = "fillRange";
    public static final String CHEST_RANGE = "chest";

    public RitualFullStomach() {
        super("ritualFullStomach", 0, 100000, "ritual.bloodmagic.fullStomachRitual");
        this.addBlockRange(FILL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-25, -25, -25), 51));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FILL_RANGE, 0, 25, 25);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return;
        }
        IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int lastSlot = 0;
        AreaDescriptor fillingRange = masterRitualStone.getBlockRange(FILL_RANGE);
        List playerList = world.func_72872_a(EntityPlayer.class, fillingRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            FoodStats foodStats = player.func_71024_bL();
            float satLevel = foodStats.func_75115_e();
            for (int i = lastSlot; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.extractItem(i, 1, true);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood)) continue;
                ItemFood foodItem = (ItemFood)stack.func_77973_b();
                int healAmount = foodItem.func_150905_g(stack);
                float saturationAmount = foodItem.func_150906_h(stack) * (float)healAmount * 2.0f;
                if (!(saturationAmount + satLevel <= 20.0f) && !(satLevel < 5.0f)) continue;
                foodStats.func_151686_a(foodItem, stack);
                inventory.extractItem(i, 1, false);
                ++totalEffects;
                lastSlot = i;
                break;
            }
            if (totalEffects < maxEffects) continue;
            masterRitualStone.getOwnerNetwork().causeNausea();
            break;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 100;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFullStomach();
    }
}

