/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl;

import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.api.IBloodMagicAPI;
import WayofTime.bloodmagic.api.impl.BloodMagicBlacklist;
import WayofTime.bloodmagic.api.impl.BloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.api.impl.BloodMagicValueManager;
import WayofTime.bloodmagic.util.BMLog;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;

public class BloodMagicAPI
implements IBloodMagicAPI {
    public static final BloodMagicAPI INSTANCE = new BloodMagicAPI();
    private final BloodMagicBlacklist blacklist = new BloodMagicBlacklist();
    private final BloodMagicRecipeRegistrar recipeRegistrar = new BloodMagicRecipeRegistrar();
    private final BloodMagicValueManager valueManager = new BloodMagicValueManager();
    private final Multimap<ComponentType, IBlockState> altarComponents = ArrayListMultimap.create();

    @Override
    @Nonnull
    public BloodMagicBlacklist getBlacklist() {
        return this.blacklist;
    }

    @Override
    @Nonnull
    public BloodMagicRecipeRegistrar getRecipeRegistrar() {
        return this.recipeRegistrar;
    }

    @Override
    @Nonnull
    public BloodMagicValueManager getValueManager() {
        return this.valueManager;
    }

    @Override
    public void registerAltarComponent(@Nonnull IBlockState state, @Nonnull String componentType) {
        ComponentType component = null;
        for (ComponentType type : ComponentType.VALUES) {
            if (!type.name().equalsIgnoreCase(componentType)) continue;
            component = type;
            break;
        }
        if (component != null) {
            BMLog.API_VERBOSE.info("Registered {} as a {} altar component.", state, componentType);
            this.altarComponents.put((Object)component, (Object)state);
        } else {
            BMLog.API.warn("Invalid Altar component type: {}.", componentType);
        }
    }

    @Override
    public void unregisterAltarComponent(@Nonnull IBlockState state, @Nonnull String componentType) {
        ComponentType component = null;
        for (ComponentType type : ComponentType.VALUES) {
            if (!type.name().equalsIgnoreCase(componentType)) continue;
            component = type;
            break;
        }
        if (component != null) {
            BMLog.API_VERBOSE.info("Unregistered {} from being a {} altar component.", state, componentType);
            this.altarComponents.remove((Object)component, (Object)state);
        } else {
            BMLog.API.warn("Invalid Altar component type: {}.", componentType);
        }
    }

    @Nonnull
    public List<IBlockState> getComponentStates(ComponentType component) {
        return (List)this.altarComponents.get((Object)component);
    }
}

