/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.messaging.chat;

import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.messaging.chat.AllianceMessageChannel;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.AbstractMutableMessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public class AllianceMessageChannelImpl
extends AbstractMutableMessageChannel
implements AllianceMessageChannel {
    private final Set<Faction> factions;

    public AllianceMessageChannelImpl(Faction faction) {
        FactionLogic factionLogic = EagleFactionsPlugin.getPlugin().getFactionLogic();
        HashSet<Faction> allianceFactions = new HashSet<Faction>();
        allianceFactions.add(faction);
        for (String allianceFactionName : faction.getAlliances()) {
            Faction allianceFaction = factionLogic.getFactionByName(allianceFactionName);
            if (allianceFactionName == null) continue;
            allianceFactions.add(allianceFaction);
        }
        this.factions = Collections.unmodifiableSet(allianceFactions);
        this.getReceivers();
    }

    public AllianceMessageChannelImpl(Set<Faction> factions) {
        this.factions = Collections.unmodifiableSet(factions);
        this.getReceivers();
    }

    private void getReceivers() {
        for (Faction faction : this.factions) {
            List<Player> players = EagleFactionsPlugin.getPlugin().getFactionLogic().getOnlinePlayers(faction);
            for (Player player : players) {
                super.addMember((MessageReceiver)player);
            }
        }
    }

    @Override
    public Set<Faction> getFactions() {
        return this.factions;
    }
}

