/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import java.util.UUID;

@Singleton
public class PermsManagerImpl
implements PermsManager {
    @Override
    public boolean canBreakBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionPermType.DESTROY);
    }

    @Override
    public boolean canPlaceBlock(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionPermType.PLACE);
    }

    @Override
    public boolean canInteract(UUID playerUUID, Faction playerFaction, Faction chunkFaction) {
        return this.checkFlag(playerUUID, playerFaction, chunkFaction, FactionPermType.USE);
    }

    @Override
    public boolean canClaim(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionPermType.CLAIM);
    }

    @Override
    public boolean canAttack(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionPermType.CLAIM);
    }

    @Override
    public boolean canInvite(UUID playerUUID, Faction playerFaction) {
        return this.checkFlag(playerUUID, playerFaction, FactionPermType.INVITE);
    }

    private boolean checkFlag(UUID playerUUID, Faction playerFaction, FactionPermType flagTypes) {
        FactionMemberType memberType = playerFaction.getPlayerMemberType(playerUUID);
        return playerFaction.getPerms().get((Object)memberType).get((Object)flagTypes);
    }

    private boolean checkFlag(UUID playerUUID, Faction playerFaction, Faction chunkFaction, FactionPermType flagType) {
        FactionMemberType memberType = playerFaction.getPlayerMemberType(playerUUID);
        if (memberType == null) {
            return false;
        }
        return chunkFaction.getPerms().get((Object)memberType).get((Object)flagType);
    }
}

