/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import java.util.ArrayList;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ExplosionListener
extends AbstractListener {
    public ExplosionListener(EagleFactions plugin) {
        super(plugin);
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onExplosionPre(ExplosionEvent.Pre event) {
        EventContext context = event.getContext();
        Cause cause = event.getCause();
        User user = null;
        user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (event.getCause().containsType(Player.class)) {
            user = (User)event.getCause().first(Player.class).get();
        } else if (event.getCause().containsType(User.class)) {
            user = (User)event.getCause().first(User.class).get();
        }
        Location location = event.getExplosion().getLocation();
        if (user == null) {
            if (!super.getPlugin().getProtectionManager().canExplode((Location<World>)location)) {
                event.setCancelled(true);
                return;
            }
        } else if (!super.getPlugin().getProtectionManager().canExplode((Location<World>)location, user, false)) {
            event.setCancelled(true);
            return;
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onExplosion(ExplosionEvent.Detonate event) {
        ArrayList locationList = new ArrayList(event.getAffectedLocations());
        ArrayList entityList = new ArrayList(event.getEntities());
        User user = null;
        Cause cause = event.getCause();
        EventContext context = event.getContext();
        user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (event.getCause().containsType(Player.class)) {
            user = (User)event.getCause().first(Player.class).get();
        } else if (event.getCause().containsType(User.class)) {
            user = (User)event.getCause().first(User.class).get();
        }
        for (Entity entity : entityList) {
            Location entityLocation = entity.getLocation();
            if (user != null) {
                if (super.getPlugin().getProtectionManager().canExplode((Location<World>)entityLocation, user, false)) continue;
                event.getEntities().remove(entity);
                continue;
            }
            if (super.getPlugin().getProtectionManager().canExplode((Location<World>)entityLocation)) continue;
            event.getEntities().remove(entity);
        }
        for (Location location : locationList) {
            if (user != null) {
                if (super.getPlugin().getProtectionManager().canExplode((Location<World>)location, user, false)) continue;
                event.getAffectedLocations().remove(location);
                continue;
            }
            if (super.getPlugin().getProtectionManager().canExplode((Location<World>)location)) continue;
            event.getAffectedLocations().remove(location);
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onExplosionPost(ExplosionEvent.Post event) {
        Living living;
        User user = null;
        Cause cause = event.getCause();
        EventContext context = event.getContext();
        user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (user == null && (living = (Living)context.get(EventContextKeys.IGNITER).orElse(null)) instanceof User) {
            user = (User)living;
        }
        for (Transaction transaction : event.getTransactions()) {
            BlockSnapshot blockSnapshot = (BlockSnapshot)transaction.getOriginal();
            Location location = blockSnapshot.getLocation().orElse(null);
            if (location == null) continue;
            if (user != null) {
                if (super.getPlugin().getProtectionManager().canExplode((Location<World>)location, user, false)) continue;
                event.setCancelled(true);
                return;
            }
            if (super.getPlugin().getProtectionManager().canExplode((Location<World>)location)) continue;
            event.setCancelled(true);
            return;
        }
    }
}

